package com.bxm.adx.common.report;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.adapter.AbstractPluginBuyModelAdapter;
import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.plugin.PluginHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2024/5/9
 **/
@Slf4j
@Service
public class DspWinPriceHandler {
    private final PluginHolder pluginHolder;

    public DspWinPriceHandler(PluginHolder pluginHolder) {
        this.pluginHolder = pluginHolder;
    }

    public DspWinInfo handle(BigDecimal price, Long dspId) {
        Buyer buyer = getBuyer(dspId);
        Dsp dsp = buyer.getDsp();
        String dspKey = dsp.getApiKey();
        BuyModelAdapter adapter = buyer.getModelAdapter();
        if (!(adapter instanceof AbstractPluginBuyModelAdapter)) {
            log.warn("unsupport adapter dsp-id {}", dsp);
            return null;
        }
        AbstractPluginBuyModelAdapter pluginAdapter = (AbstractPluginBuyModelAdapter) adapter;
        String macro = pluginAdapter.getPluginConfig().getProperties().getProperty(AdxConstants.PluginParam.MACRO_WIN_PRICE);
        if (StringUtils.isBlank(macro)) {
            log.warn("marco is null dsp-id {}", dsp);
            return null;
        }

        BigDecimal dspWinPrice = pluginAdapter.priceScale(price);
        String cipher = pluginAdapter.encrypt(dspWinPrice.toString(), dspKey);
        if (StringUtils.isBlank(cipher)) {
            log.warn("cipher is null dsp-id {}", dsp);
            return null;
        }
        return DspWinInfo.builder()
                .win(dspWinPrice)
                .cipher(cipher)
                .macro(macro)
                .build();
    }

    private Buyer getBuyer(Long dspId) {
        Map<String, Buyer> buyers = pluginHolder.getBuyers();
        for (Map.Entry<String, Buyer> entry : buyers.entrySet()) {
            Buyer buyer = entry.getValue();
            Dsp dsp = buyer.getDsp();
            if (Objects.nonNull(dsp)) {
                if (dsp.getId().equals(dspId)) {
                    return buyer;
                }
            }
        }
        return null;
    }
}
