package com.bxm.adx.common.utils;

import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/**
 * @author allen
 * @date 2019/6/26
 * @since 1.0.0
 */
@Slf4j
public final class ServletUtils {

    public static byte[] getBodyForBuffer(HttpServletRequest request) {
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;

        try {
            if (isGzip(request)) {
                inputStream = new GZIPInputStream(request.getInputStream());
            } else {
                inputStream = request.getInputStream();
            }
            outputStream = new ByteArrayOutputStream();
            int len = -1;

            // 设置缓冲区大小
            byte[] buff = new byte[2048];

            while ((len = inputStream.read(buff)) != -1) {
                outputStream.write(buff, 0, len);
            }
            outputStream.flush();
            return outputStream.toByteArray();
        } catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("read request input stream occur error!", e);
            }
            return new byte[0];
        } finally {
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static void println(HttpServletResponse response, byte[] data, Map<String, String> header) {
        println(response, data, header, true);
    }

    public static void println(HttpServletResponse response, byte[] data, Map<String, String> header, boolean closeStream) {
        ServletOutputStream out = null;
        try {
            if (!CollectionUtils.isEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    response.setHeader(entry.getKey(), entry.getValue());
                }
            }
            out = response.getOutputStream();
            if (data != null) {
                out.write(data);
            }

            out.flush();
        } catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("writer resp body err", e);
            }
        } finally {
            if (closeStream) {
                // 尽量不要让容器来关闭
                IOUtils.closeQuietly(out);
            }
        }
    }

    public static byte[] convert2JsonBytes(Map<String, String[]> map) {
        Map<String, Object> map1 = new HashMap<>(map.size());
        for (Map.Entry<String, String[]> stringEntry : map.entrySet()) {
            Object strKey = stringEntry.getKey();
            String[] strObj = stringEntry.getValue();
            map1.put(strKey.toString(), strObj[0]);
        }
        return JsonHelper.convert2bytes(map1);
    }

    private static boolean isGzip(HttpServletRequest request) {
        String encoding = request.getHeader("Content-Encoding");
        if (StringUtils.isNotEmpty(encoding) && "gzip".equalsIgnoreCase(encoding)) {
            return true;
        }
        return false;
    }
}
