/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.DeviceCrowdPackageJedisProperties;
import com.bxm.adx.common.buy.dispatcher.filter.BlackCrowdPackageFilter;
import com.bxm.adx.common.buy.dispatcher.filter.WhiteCrowdPackageFilter;
import com.bxm.adx.common.limiter.DefaultDeleteExpiredHandler;
import com.bxm.adx.common.limiter.DefaultInsertExpireHandler;
import com.bxm.adx.common.limiter.DeleteExpiredHandler;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.market.nbr.BlockDeviceHandler;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

@ConditionalOnProperty(prefix="adx", value={"enable-crowd"}, havingValue="true")
@EnableConfigurationProperties(value={DeviceCrowdPackageJedisProperties.class})
public class DeviceCrowdPackageJedisAutoConfiguration {
    private final DeviceCrowdPackageJedisProperties properties;

    public DeviceCrowdPackageJedisAutoConfiguration(DeviceCrowdPackageJedisProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"crowdPackJedisPool"})
    public JedisPool crowdPackJedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.properties, this.properties.getHost(), this.properties.getPort(), this.properties.getTimeout(), this.properties.getPassword(), this.properties.getDatabase());
    }

    @Bean(name={"crowdPackFetcher"})
    public JedisFetcher crowdPackFetcher(@Qualifier(value="crowdPackJedisPool") JedisPool crowdPackJedisPool) {
        return new JedisFetcher(crowdPackJedisPool);
    }

    @Bean(name={"crowdPackUpdater"})
    public JedisUpdater crowdPackUpdater(@Qualifier(value="crowdPackJedisPool") JedisPool crowdPackJedisPool) {
        return new JedisUpdater(crowdPackJedisPool);
    }

    @Bean(name={"crowdPackCounter"})
    public JedisCounter crowdPackCounter(@Qualifier(value="crowdPackJedisPool") JedisPool crowdPackJedisPool) {
        return new JedisCounter(crowdPackJedisPool);
    }

    @Bean(value={"deleteExpiredDeviceCrowdPackageHandler"})
    public DeleteExpiredHandler deleteExpiredDeviceCrowdPackageHandler(@Qualifier(value="crowdPackUpdater") Updater updater) {
        return new DefaultDeleteExpiredHandler(updater);
    }

    @Bean(value={"insertExpireDeviceCrowdPackageHandler"})
    public InsertExpireHandler insertExpireDeviceCrowdPackageHandler(@Qualifier(value="crowdPackUpdater") Updater updater, @Qualifier(value="crowdPackFetcher") Fetcher fetcher) {
        return new DefaultInsertExpireHandler(updater, fetcher);
    }

    @Bean
    public WhiteCrowdPackageFilter whiteCrowdPackageFilter(@Qualifier(value="crowdPackFetcher") Fetcher fetcher, @Qualifier(value="deleteExpiredDeviceCrowdPackageHandler") DeleteExpiredHandler deleteExpiredHandler) {
        return new WhiteCrowdPackageFilter(fetcher, deleteExpiredHandler);
    }

    @Bean
    public BlackCrowdPackageFilter blackCrowdPackageFilter(@Qualifier(value="crowdPackFetcher") Fetcher fetcher, @Qualifier(value="deleteExpiredDeviceCrowdPackageHandler") DeleteExpiredHandler deleteExpiredHandler) {
        return new BlackCrowdPackageFilter(fetcher, deleteExpiredHandler);
    }

    @Bean
    public BlockDeviceHandler blockDeviceHandler(@Qualifier(value="insertExpireDeviceCrowdPackageHandler") InsertExpireHandler insertExpireHandler) {
        return new BlockDeviceHandler(insertExpireHandler, this.properties);
    }
}

