/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import cn.hutool.core.collection.ConcurrentHashSet;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigChangeHandler;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherConfig;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.limiter.DeleteExpiredHandler;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.rule.WhiteAndBlackRule;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCrowdPackageFilter
implements DispatcherFilter<Dispatcher>,
DispatcherABConfigChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractCrowdPackageFilter.class);
    protected Fetcher fetcher;
    protected DeleteExpiredHandler deleteExpiredHandler;
    protected final ConcurrentHashMap<String, Set<String>> dispatcherBlackCrowdIds = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Set<String>> dispatcherWhiteCrowdIds = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Set<String>> dispatcherCrowdIds = new ConcurrentHashMap();

    public AbstractCrowdPackageFilter(Fetcher fetcher, DeleteExpiredHandler deleteExpiredHandler) {
        this.fetcher = fetcher;
        this.deleteExpiredHandler = deleteExpiredHandler;
    }

    @Override
    public void doUpdate(DispatcherABConfig old, DispatcherABConfig latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            List<DispatcherConfig> dispatcherConfigs = latest.getDispatcherConfigCaches();
            if (CollectionUtils.isEmpty(dispatcherConfigs)) {
                return;
            }
            for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
                List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
                if (CollectionUtils.isEmpty(dispatchers)) continue;
                for (Dispatcher dispatcher : dispatchers) {
                    if (dispatcher.getOpened() == 0) continue;
                    Rule rule = dispatcher.getCrowdPackageOrientation();
                    String id = dispatcher.getId();
                    if (Objects.isNull(rule)) continue;
                    WhiteAndBlackRule whiteAndBlackRule = new WhiteAndBlackRule(rule);
                    WhiteAndBlackRule.WhiteAndBlack whiteAndBlackSet = whiteAndBlackRule.getWhiteAndBlack();
                    ((Set)MapHelper.get(this.dispatcherBlackCrowdIds, id, new ConcurrentHashSet())).addAll(whiteAndBlackSet.getBlack());
                    ((Set)MapHelper.get(this.dispatcherWhiteCrowdIds, id, new ConcurrentHashSet())).addAll(whiteAndBlackSet.getWhite());
                    ((Set)MapHelper.get(this.dispatcherCrowdIds, id, new ConcurrentHashSet())).addAll(whiteAndBlackSet.getAll());
                }
            }
        }
    }

    @Override
    public void doDelete(DispatcherABConfig old) {
        List<DispatcherConfig> dispatcherConfigs = old.getDispatcherConfigCaches();
        if (CollectionUtils.isEmpty(dispatcherConfigs)) {
            return;
        }
        for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
            List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
            if (CollectionUtils.isEmpty(dispatchers)) continue;
            for (Dispatcher dispatcher : dispatchers) {
                Rule rule = dispatcher.getCrowdPackageOrientation();
                if (Objects.isNull(rule)) continue;
                this.dispatcherBlackCrowdIds.remove(dispatcher.getId());
                this.dispatcherWhiteCrowdIds.remove(dispatcher.getId());
                this.dispatcherCrowdIds.remove(dispatcher.getId());
            }
        }
    }

    protected Set<String> getUserCrowdPackageSet(DispatcherContext<Dispatcher> context) {
        Set<String> userCrowds = context.getUserCrowds();
        if (Objects.nonNull(userCrowds)) {
            return userCrowds;
        }
        HashSet<String> userCrowdPackageSet = new HashSet<String>();
        KeyGenerator key = CacheKeys.getCrowdPackageNewKey(context.getRequest().getDevice());
        if (Objects.nonNull(key)) {
            if (log.isDebugEnabled()) {
                log.debug("key {}", (Object)key.generateKey());
            }
            long currentSecond = System.currentTimeMillis() / 1000L;
            Map idAndExpireSecondMap = this.fetcher.hfetchall(key, Long.class);
            if (MapUtils.isNotEmpty((Map)idAndExpireSecondMap)) {
                for (Map.Entry entry : idAndExpireSecondMap.entrySet()) {
                    String id = (String)entry.getKey();
                    if ((Long)entry.getValue() > currentSecond) {
                        userCrowdPackageSet.add(id);
                        continue;
                    }
                    this.deleteExpiredHandler.delete(key, id);
                }
            }
        }
        context.setUserCrowds(userCrowdPackageSet);
        return userCrowdPackageSet;
    }

    protected boolean hit(DispatcherContext<Dispatcher> context, Set<String> configSet) {
        if (CollectionUtils.isEmpty(configSet)) {
            return false;
        }
        Set<String> userCrowdSet = this.getUserCrowdPackageSet(context);
        if (CollectionUtils.isNotEmpty(userCrowdSet)) {
            for (String id : configSet) {
                if (!userCrowdSet.contains(id)) continue;
                return true;
            }
        }
        return false;
    }
}

