/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class LimitConfig {
    private LimitType type;
    private Integer timeWindow;
    private TimeUnit timeUnit;
    private Integer limit;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitConfig that = (LimitConfig)o;
        return this.getType().equals((Object)that.getType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType()});
    }

    LimitConfig(LimitType type, Integer timeWindow, TimeUnit timeUnit, Integer limit) {
        this.type = type;
        this.timeWindow = timeWindow;
        this.timeUnit = timeUnit;
        this.limit = limit;
    }

    public static LimitConfigBuilder builder() {
        return new LimitConfigBuilder();
    }

    public LimitType getType() {
        return this.type;
    }

    public Integer getTimeWindow() {
        return this.timeWindow;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setType(LimitType type) {
        this.type = type;
    }

    public void setTimeWindow(Integer timeWindow) {
        this.timeWindow = timeWindow;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String toString() {
        return "LimitConfig(type=" + (Object)((Object)this.getType()) + ", timeWindow=" + this.getTimeWindow() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", limit=" + this.getLimit() + ")";
    }

    public static class LimitConfigBuilder {
        private LimitType type;
        private Integer timeWindow;
        private TimeUnit timeUnit;
        private Integer limit;

        LimitConfigBuilder() {
        }

        public LimitConfigBuilder type(LimitType type) {
            this.type = type;
            return this;
        }

        public LimitConfigBuilder timeWindow(Integer timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public LimitConfigBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public LimitConfigBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public LimitConfig build() {
            return new LimitConfig(this.type, this.timeWindow, this.timeUnit, this.limit);
        }

        public String toString() {
            return "LimitConfig.LimitConfigBuilder(type=" + (Object)((Object)this.type) + ", timeWindow=" + this.timeWindow + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", limit=" + this.limit + ")";
        }
    }

    public static enum LimitType {
        REQUEST(1),
        BID(2),
        SHOW(3),
        CLICK(4);

        private int type;

        private LimitType(int type) {
            this.type = type;
        }

        public static LimitType getLimitType(int type) {
            return Arrays.stream(LimitType.values()).filter(limitType -> limitType.getType() == type).findFirst().orElse(null);
        }

        public int getType() {
            return this.type;
        }
    }
}

