/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.log.buriedSwitch;

import com.bxm.adx.common.log.buriedSwitch.BuriedSwitch;
import com.bxm.adx.common.log.buriedSwitch.BuriedSwitchCaching;
import com.bxm.adx.common.log.buriedSwitch.BuriedSwitchDao;
import com.bxm.mccms.facade.model.pushable.BuriedSwitchCashVO;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CachePush(value="BURIED_SWITCH")
public class BuriedSwitchDaoImpl
implements BuriedSwitchDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(BuriedSwitchDaoImpl.class);
    private final DataSyncProducer dataSyncProducer;
    private final BuriedSwitchCaching buriedSwitchCaching;

    public BuriedSwitchDaoImpl(DataSyncProducer dataSyncProducer, BuriedSwitchCaching buriedSwitchCaching) {
        this.dataSyncProducer = dataSyncProducer;
        this.buriedSwitchCaching = buriedSwitchCaching;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        BuriedSwitchCashVO convert;
        if (log.isInfoEnabled()) {
            log.info("buried switch data = {}", JsonHelper.convert((byte[])data, String.class));
        }
        if ((convert = (BuriedSwitchCashVO)JsonHelper.convert((byte[])data, BuriedSwitchCashVO.class)) == null || convert.getId() == null) {
            return;
        }
        String key = convert.getClass().getName() + "$" + convert.getId();
        this.dataSyncProducer.post(key, (Object)convert);
    }

    @Override
    public Boolean getBuriedSwitch(String positionId, Long dspId, String dspPosid) {
        BuriedSwitch buriedSwitch = (BuriedSwitch)this.buriedSwitchCaching.get(positionId + "_" + dspId + "_" + dspPosid);
        if (buriedSwitch == null || buriedSwitch.getOpened() == null || buriedSwitch.getOpened() == 0) {
            return false;
        }
        return true;
    }
}

