/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.utils.MapHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class ExchangeResult {
    private List<Deal> deals = new ArrayList<Deal>();
    private Map<Integer, Set<Deal>> trash;
    private Collection<BuyerWrapper> buyers = new ArrayList<BuyerWrapper>();

    public void addTrash(Map<Integer, Set<Deal>> trashMap) {
        if (CollectionUtils.isEmpty(trashMap)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.trash)) {
            this.trash = trashMap;
            return;
        }
        for (Map.Entry<Integer, Set<Deal>> entry : trashMap.entrySet()) {
            Set<Deal> val = entry.getValue();
            if (CollectionUtils.isEmpty(val)) continue;
            ((Set)MapHelper.get(this.trash, entry.getKey(), new HashSet())).addAll(val);
        }
    }

    public boolean exchangeSuccess() {
        return !CollectionUtils.isEmpty(this.deals);
    }

    public List<Deal> getDeals() {
        return this.deals;
    }

    public Map<Integer, Set<Deal>> getTrash() {
        return this.trash;
    }

    public Collection<BuyerWrapper> getBuyers() {
        return this.buyers;
    }

    public void setDeals(List<Deal> deals) {
        this.deals = deals;
    }

    public void setTrash(Map<Integer, Set<Deal>> trash) {
        this.trash = trash;
    }

    public void setBuyers(Collection<BuyerWrapper> buyers) {
        this.buyers = buyers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExchangeResult)) {
            return false;
        }
        ExchangeResult other = (ExchangeResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Deal> this$deals = this.getDeals();
        List<Deal> other$deals = other.getDeals();
        if (this$deals == null ? other$deals != null : !((Object)this$deals).equals(other$deals)) {
            return false;
        }
        Map<Integer, Set<Deal>> this$trash = this.getTrash();
        Map<Integer, Set<Deal>> other$trash = other.getTrash();
        if (this$trash == null ? other$trash != null : !((Object)this$trash).equals(other$trash)) {
            return false;
        }
        Collection<BuyerWrapper> this$buyers = this.getBuyers();
        Collection<BuyerWrapper> other$buyers = other.getBuyers();
        return !(this$buyers == null ? other$buyers != null : !((Object)this$buyers).equals(other$buyers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExchangeResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Deal> $deals = this.getDeals();
        result = result * 59 + ($deals == null ? 43 : ((Object)$deals).hashCode());
        Map<Integer, Set<Deal>> $trash = this.getTrash();
        result = result * 59 + ($trash == null ? 43 : ((Object)$trash).hashCode());
        Collection<BuyerWrapper> $buyers = this.getBuyers();
        result = result * 59 + ($buyers == null ? 43 : ((Object)$buyers).hashCode());
        return result;
    }

    public String toString() {
        return "ExchangeResult(deals=" + this.getDeals() + ", trash=" + this.getTrash() + ", buyers=" + this.getBuyers() + ")";
    }
}

