/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.filter;

import cn.hutool.core.util.RandomUtil;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilter;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferFactory;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BidPriceTop1DispatcherPriceConfigFilter
implements DispatcherPriceConfigFilter {
    private static final Logger log = LoggerFactory.getLogger(BidPriceTop1DispatcherPriceConfigFilter.class);
    private final OfferFactory factory;

    public BidPriceTop1DispatcherPriceConfigFilter(OfferFactory factory) {
        this.factory = factory;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        if (priceConfigs.size() == 1) {
            return;
        }
        priceConfigs.removeIf(config -> "\u9ed8\u8ba4\u51fa\u4ef7\u7b56\u7565".equals(config.getPriceModeName()));
        if (priceConfigs.size() > 1) {
            ArrayList<DispatcherPriceConfig> dispatcherPriceConfigs = new ArrayList<DispatcherPriceConfig>(priceConfigs);
            DispatcherPriceConfig dispatcherPriceConfig = (DispatcherPriceConfig)dispatcherPriceConfigs.get(RandomUtil.randomInt((int)priceConfigs.size()));
            priceConfigs.clear();
            priceConfigs.add(dispatcherPriceConfig);
        }
    }
}

