/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilter;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LowPriceDispatcherPriceConfigFilter
implements DispatcherPriceConfigFilter {
    private static final Logger log = LoggerFactory.getLogger(LowPriceDispatcherPriceConfigFilter.class);

    public int getOrder() {
        return 40;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        boolean isCpc = this.isCpc(bid);
        BigDecimal price = !isCpc ? bid.getPrice() : bid.getBid();
        if (Objects.isNull(price)) {
            return;
        }
        BigDecimal finalPrice = price;
        priceConfigs.removeIf(config -> config.getFilterDspPrice() != null && finalPrice.compareTo(config.getFilterDspPrice().movePointRight(2)) < 0);
    }

    private boolean isCpc(Bid bid) {
        if (Objects.isNull(bid.getCharge_type())) {
            return false;
        }
        return 2 == bid.getCharge_type();
    }
}

