/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BidByDspPriceOffer
implements Offer {
    private static final Logger log = LoggerFactory.getLogger(BidByDspPriceOffer.class);

    @Override
    public OfferResult offer(Bid bid, BidRequest request, Dispatcher dispatcher, DispatcherPriceConfig priceConfig) {
        OfferResult.OfferResultBuilder builder = OfferResult.builder().chargeType(2).budgetType(2);
        Integer bidModel = request.getBid_model();
        if (bidModel != 2) {
            log.warn("BidByDspPriceOffer bidModel is not CPC\uff01strategyId:{}", (Object)dispatcher.getStrategyId());
            return builder.build();
        }
        BigDecimal bidPrice = bid.getBid();
        if (bidPrice == null) {
            log.warn("BidByDspPriceOffer bidPrice is empty\uff01");
            return builder.build();
        }
        if (bidPrice.compareTo(BigDecimal.ZERO) == 0) {
            log.warn("BidByDspPriceOffer bidPrice = 0\uff01bidId:{}", (Object)bid.getId());
            return builder.offer(bidPrice).build();
        }
        BigDecimal profitMargin = priceConfig.getProfitMargin();
        if (profitMargin == null) {
            log.warn("BidByDspPriceOffer profitMargin is empty\uff01positionId:{},strategyId:{},priceModeName:{}", new Object[]{dispatcher.getPositionId(), dispatcher.getStrategyId(), priceConfig.getPriceModeName()});
            return builder.build();
        }
        BigDecimal cpcUpperLimit = priceConfig.getCpcUpperLimit();
        if (cpcUpperLimit == null) {
            log.warn("BidByDspPriceOffer cpcUpperLimit is empty\uff01positionId:{},strategyId:{},priceModeName:{}", new Object[]{dispatcher.getPositionId(), dispatcher.getStrategyId(), priceConfig.getPriceModeName()});
            return builder.build();
        }
        BigDecimal newBidPrice = bidPrice.multiply(new BigDecimal(1).subtract(profitMargin.movePointLeft(2))).setScale(0, RoundingMode.FLOOR);
        return builder.offer(newBidPrice.min(cpcUpperLimit.movePointRight(2)).setScale(2, RoundingMode.FLOOR)).build();
    }

    @Override
    public OfferType offerType() {
        return OfferType.Bid_By_Dsp;
    }
}

