/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.mccms.facade.enums.OfferSettle;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DspAvgPriceDiscountOffer
implements Offer {
    private static final Logger log = LoggerFactory.getLogger(DspAvgPriceDiscountOffer.class);

    @Override
    public OfferResult offer(Bid bid, BidRequest request, Dispatcher dispatcher, DispatcherPriceConfig priceConfig) {
        Integer bidModel;
        String mediaSettle = dispatcher.getMediaSettle();
        int chargeType = 1;
        int budgetType = 1;
        if (Objects.nonNull(mediaSettle) && OfferSettle.CPC.name().equalsIgnoreCase(mediaSettle)) {
            log.warn("warn cpc model");
            chargeType = 2;
            budgetType = 2;
        }
        if (Objects.nonNull(bidModel = request.getBid_model())) {
            switch (bidModel) {
                case 2: {
                    chargeType = 2;
                    budgetType = 2;
                }
            }
        }
        return OfferResult.builder().chargeType(chargeType).budgetType(budgetType).offer(this.getOffer(dispatcher, bid, priceConfig)).build();
    }

    @Override
    public OfferType offerType() {
        return OfferType.Dsp_Avg_Price_Discount;
    }

    private BigDecimal getOffer(Dispatcher dispatcher, Bid bid, DispatcherPriceConfig bidPriceConfig) {
        BigDecimal dspCpmPrice;
        if (Objects.nonNull(bidPriceConfig) && Objects.nonNull(dspCpmPrice = bidPriceConfig.getDspCpmPrice())) {
            return dspCpmPrice.movePointRight(2);
        }
        log.error("dispatcher {} dsp-cpm empty", (Object)dispatcher.getId());
        return bid.getPrice();
    }
}

