/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.adapter.AbstractPluginBuyModelAdapter;
import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.integration.pair.Pair;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class DspWinPriceBuilder
implements AdxBidResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(DspWinPriceBuilder.class);
    private final String SECOND_AUCTION_DSP_LIST = "adx.second.auction.dsp";
    private final Pair pair;
    private static final List<String> MEDIA_LIST = Lists.newArrayList((Object[])new String[]{"1", "42"});

    public DspWinPriceBuilder(Pair pair) {
        this.pair = pair;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Buyer buyer = attribute.getBuyer();
        Dsp dsp = buyer.getDsp();
        String dspKey = dsp.getApiKey();
        BuyModelAdapter adapter = buyer.getModelAdapter();
        if (!(adapter instanceof AbstractPluginBuyModelAdapter)) {
            return;
        }
        AbstractPluginBuyModelAdapter pluginAdapter = (AbstractPluginBuyModelAdapter)adapter;
        String macro = pluginAdapter.getPluginConfig().getProperties().getProperty("mwp");
        if (StringUtils.isBlank((CharSequence)macro)) {
            return;
        }
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                if (Objects.nonNull(bid.getDspWinPrice())) continue;
                Integer chargeType = DspWinPriceBuilder.getChargeType(bid);
                BigDecimal dspWinPrice = DspWinPriceBuilder.getWinPrice(chargeType, bid, attribute);
                if (this.check(attribute) && this.isSecondAuction(bid, attribute, chargeType, dspWinPrice)) continue;
                dspWinPrice = pluginAdapter.priceScale(dspWinPrice);
                bid.setDspWinPrice(dspWinPrice);
                String cipher = pluginAdapter.encrypt(dspWinPrice.toString(), dspKey);
                if (StringUtils.isBlank((CharSequence)cipher)) continue;
                switch (chargeType) {
                    case 1: {
                        List<ImpMonitor> impMonitors = bid.getImp_monitors();
                        if (CollectionUtils.isEmpty(impMonitors)) break;
                        impMonitors.forEach(impMonitor -> {
                            String imp = impMonitor.getImp_monitor_url().replace(macro, cipher);
                            impMonitor.setImp_monitor_url(imp);
                        });
                        break;
                    }
                    case 2: {
                        List<ClickMonitor> clickMonitors = bid.getClick_monitors();
                        if (CollectionUtils.isEmpty(clickMonitors)) break;
                        clickMonitors.forEach(clickMonitor -> {
                            String click = clickMonitor.getClick_monitor_url().replace(macro, cipher);
                            clickMonitor.setClick_monitor_url(click);
                        });
                    }
                }
            }
        }
    }

    public int getOrder() {
        return 4;
    }

    private boolean check(ResponseBuildAttribute attribute) {
        List dspIds = this.pair.get("adx.second.auction.dsp").ofArrayList();
        if (CollectionUtils.isEmpty((Collection)dspIds)) {
            return false;
        }
        String id = attribute.getBuyer().getDsp().getId().toString();
        String mediaId = attribute.getBidRequest().getMediaId();
        return dspIds.contains(id) && MEDIA_LIST.contains(mediaId);
    }

    private boolean isSecondAuction(Bid bid, ResponseBuildAttribute attribute, Integer chargeType, BigDecimal dspWinPrice) {
        DispatcherPriceConfig priceConfig = attribute.getBidPriceConfig(bid);
        if (Objects.nonNull(priceConfig)) {
            boolean isSecondAuction = false;
            switch (chargeType) {
                case 1: {
                    Integer winPriceType = priceConfig.getAdvertiserWinPriceType();
                    boolean bl = isSecondAuction = Objects.nonNull(winPriceType) && 1 == winPriceType;
                    if (!isSecondAuction) break;
                    bid.setAdv_wpt(winPriceType);
                    BigDecimal advertiserProfitMargin = priceConfig.getAdvertiserProfitMargin();
                    if (Objects.isNull(advertiserProfitMargin)) {
                        log.warn("position {} config {} adv-pm is null", (Object)priceConfig.getPositionId(), (Object)priceConfig.getPositionId());
                    }
                    bid.setAdv_pm(advertiserProfitMargin);
                    bid.setDsp_dis_price(dspWinPrice);
                    break;
                }
                case 2: {
                    Integer offerType = priceConfig.getAdvertiserOfferType();
                    boolean bl = isSecondAuction = Objects.nonNull(offerType) && 4 == offerType;
                    if (!isSecondAuction) break;
                    bid.setAdv_wpt(1);
                    BigDecimal advertiserProfitMargin = priceConfig.getAdvertiserProfitMargin();
                    if (Objects.isNull(advertiserProfitMargin)) {
                        log.warn("position {} config {} adv-pm is null", (Object)priceConfig.getPositionId(), (Object)priceConfig.getPositionId());
                    }
                    bid.setAdv_pm(advertiserProfitMargin);
                }
            }
            return isSecondAuction;
        }
        return false;
    }

    private static BigDecimal getWinPrice(Integer chargeType, Bid bid, ResponseBuildAttribute attribute) {
        BigDecimal price = bid.getDsp_price();
        Dispatcher dispatcher = attribute.getDispatcher();
        switch (chargeType) {
            case 1: {
                return DspWinPriceBuilder.getCpmWinPrice(price, bid, attribute);
            }
            case 2: {
                return DspWinPriceBuilder.getCpcWinPrice(price, bid, attribute);
            }
        }
        throw new AdxException(AdxErrEnum.UNKNOWN_ERR);
    }

    private static Integer getChargeType(Bid bid) {
        Integer chargeType = bid.getCharge_type();
        return Objects.isNull(chargeType) ? 1 : chargeType;
    }

    private static BigDecimal getCpmWinPrice(BigDecimal dspOffer, Bid bid, ResponseBuildAttribute attribute) {
        DispatcherPriceConfig config = attribute.getBidPriceConfig(bid);
        if (Objects.isNull(config)) {
            return dspOffer;
        }
        BigDecimal priceSplit = config.getPriceSplit();
        BigDecimal lt = config.getLtPriceDiscountFactor();
        BigDecimal gt = config.getGtPriceDiscountFactor();
        if (Objects.isNull(priceSplit)) {
            lt = Optional.ofNullable(lt).orElse(BigDecimal.ONE);
            return dspOffer.multiply(lt);
        }
        int compare = dspOffer.compareTo(priceSplit = priceSplit.movePointRight(2));
        if (compare <= 0) {
            return dspOffer.multiply(lt);
        }
        BigDecimal ltPrice = priceSplit.multiply(lt);
        BigDecimal gtPrice = dspOffer.subtract(priceSplit).multiply(gt);
        return ltPrice.add(gtPrice);
    }

    private static BigDecimal getCpcWinPrice(BigDecimal dspOffer, Bid bid, ResponseBuildAttribute attribute) {
        DispatcherPriceConfig config = attribute.getBidPriceConfig(bid);
        if (Objects.isNull(config)) {
            return dspOffer;
        }
        Integer type = config.getAdvertiserOfferType();
        if (Objects.isNull(type)) {
            log.warn("dispatcher {} advert win type is null", (Object)attribute.getDispatcher().getId());
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
        if (4 == type) {
            return null;
        }
        BigDecimal price = config.getAdvertiserOfferPrice();
        if (Objects.isNull(price)) {
            log.warn("dispatcher {} advert offer price is empty", (Object)attribute.getDispatcher().getId());
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
        if ((price = price.movePointRight(2)).compareTo(dspOffer) > 0) {
            return dspOffer;
        }
        return price;
    }
}

