/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BidModelFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BidModelFilter.class);

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set remove = deals.stream().filter(deal -> {
            Integer bidModel = deal.getBidRequest().getBid_model();
            BidResponse response = deal.getBidResponse();
            List<SeatBid> seatBids = response.getSeat_bid();
            seatBids.removeIf(seatBid -> {
                List<Bid> bidList = seatBid.getBid();
                bidList.removeIf(b -> !b.getCharge_type().equals(bidModel));
                return CollectionUtils.isEmpty(bidList);
            });
            return CollectionUtils.isEmpty(seatBids);
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

