/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.DealFilterCondition;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@DealFilterCondition(chargeType=2)
public class CpcPriceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CpcPriceFilter.class);
    @Resource
    private AdxProperties properties;

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        deals.stream().map(Deal::getBidResponse).map(BidResponse::getSeat_bid).flatMap(Collection::stream).map(SeatBid::getBid).forEach(bids -> {
            bids.sort(Comparator.comparing(Bid::getBid).reversed());
            if (this.properties.getMaxCreativesOfCpc() < bids.size()) {
                bids.subList(this.properties.getMaxCreativesOfCpc(), bids.size()).clear();
            }
        });
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

