/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.DealFilterCondition;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@DealFilterCondition(preview=true)
public class NoBidFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(NoBidFilter.class);

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set remove = deals.stream().filter(deal -> {
            Boolean bidSuccess = deal.getBidSuccess();
            if (Objects.nonNull(bidSuccess)) {
                return bidSuccess == false;
            }
            BidResponse response = deal.getBidResponse();
            if (null == response) {
                return true;
            }
            List<SeatBid> seatBidList = response.getSeat_bid();
            if (CollectionUtils.isEmpty(seatBidList)) {
                return true;
            }
            seatBidList.removeIf(seatBid -> {
                List<Bid> bidList = seatBid.getBid();
                return CollectionUtils.isEmpty(bidList);
            });
            return CollectionUtils.isEmpty(seatBidList);
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return -2147483647;
    }
}

