/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.external;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.DotEventControlProperties;
import com.bxm.adx.common.openlog.event.external.AdShowEvent;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdShowForDspAvgExposureLimiterEventListener
implements EventListener<AdShowEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdShowForDspAvgExposureLimiterEventListener.class);
    private final Counter counter;
    private final AdxProperties adxProperties;
    private final int EXPIRE_SECONDS_12_HOURS = 43200;
    private final int EXPIRE_SECONDS_24_HOURS = 86400;

    public AdShowForDspAvgExposureLimiterEventListener(Counter counter, AdxProperties adxProperties) {
        this.counter = counter;
        this.adxProperties = adxProperties;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdShowEvent event) {
        this.handleDspAvgExposure(event);
    }

    private void handleDspAvgExposure(AdShowEvent event) {
        LocalDateTime now;
        String dspTagId;
        KeyValueMap map = event.getLog();
        String dspId = (String)map.getFirst((Object)"dspid");
        DotEventControlProperties control = this.needControl(dspId, dspTagId = (String)map.getFirst((Object)"dtagid"), now = LocalDateTime.now());
        if (Objects.isNull(control)) {
            return;
        }
        KeyGenerator sectionKey = AdxKeyGenerator.Counter.getDspPositionExposureBySection((String)control.getId(), (String)control.getSectionId(now), (String)dspId, (String)dspTagId);
        KeyGenerator controlKey = AdxKeyGenerator.Counter.getDspPositionExposureByControl((String)control.getId(), (String)dspId, (String)dspTagId);
        this.counter.incrementAndGet(sectionKey, 43200);
        this.counter.incrementAndGet(controlKey, 86400);
    }

    private DotEventControlProperties needControl(String dspId, String dspTagId, LocalDateTime now) {
        List<DotEventControlProperties> properties = this.adxProperties.getDotEventControls();
        if (CollectionUtils.isEmpty(properties)) {
            return null;
        }
        Optional<DotEventControlProperties> optional = properties.stream().filter(p -> Objects.nonNull(p.getMt()) && 5 == p.getMt()).filter(p -> p.getDspId().equals(dspId)).filter(p -> p.getDspPositionId().equals(dspTagId)).filter(p -> now.isAfter(p.getStart()) && now.isBefore(p.getEnd())).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }
}

