/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.external;

import com.bxm.adx.common.openlog.event.external.AdShowEvent;
import com.bxm.adx.common.report.ReportParam;
import com.bxm.adx.common.report.ReportType;
import com.bxm.adx.common.report.ServerReportConfig;
import com.bxm.adx.common.report.ServerReportService;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AdShowForServerReportEventListener
implements EventListener<AdShowEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdShowForServerReportEventListener.class);
    private final ServerReportService serverReportService;

    public AdShowForServerReportEventListener(ServerReportService serverReportService) {
        this.serverReportService = serverReportService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdShowEvent event) {
        String appId;
        KeyValueMap map = event.getLog();
        String bidId = (String)map.getFirst((Object)"bidid");
        String dspId = (String)map.getFirst((Object)"dspid");
        String mediaId = (String)map.getFirst((Object)"medid");
        ServerReportConfig config = this.serverReportService.getConfig(mediaId, appId = (String)map.getFirst((Object)"appid"), dspId, bidId);
        if (Objects.isNull(config)) {
            return;
        }
        ReportParam reportParam = ReportParam.builder().bidId(bidId).dspId(dspId).mediaId(mediaId).appId(appId).type(ReportType.IMP).chargeType((String)map.getFirst((Object)"chgtypm")).adId((String)map.getFirst((Object)"adid")).mediaWinPrice((String)map.getFirst((Object)"win_price")).advWinPriceModel((String)map.getFirst((Object)"dwm")).dspPriceConfig((String)map.getFirst((Object)"dprwc")).build();
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"User-Agent", map.getFirst((Object)"ua"));
        this.serverReportService.report(reportParam, (MultiValueMap<String, String>)headers, map);
    }
}

