/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.market.exchange.rebuild.filter.FilterInfo;
import com.bxm.adx.common.openlog.event.internal.AdxDispatcherPriceConfigFilter;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
public class DotAdxDispatcherPriceConfigFilterEventListener
implements EventListener<AdxDispatcherPriceConfigFilter> {
    private static final Logger log = LoggerFactory.getLogger(DotAdxDispatcherPriceConfigFilterEventListener.class);
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotAdxDispatcherPriceConfigFilterEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxDispatcherPriceConfigFilter event) {
        if (Math.abs(event.getBidRequest().getId().hashCode() % 100) >= this.properties.getDotSimplingPercent()) {
            return;
        }
        MultiValueMap<String, String> customizeParams = this.buildCustomizeParams(event.getFilterInfos());
        String url = this.properties.getOpenLog().create(true, 43, customizeParams, OpenlogConstants.WITHOUT_MACROS_INNER);
        BuildAttribute attribute = new BuildAttribute(3).setDspId(event.getBuyer().getDsp().getId()).setSspRequest(event.getBidRequest()).setAdxRequest(event.getAdxRequest()).setConfigId(event.getDispatcher().getConfigId()).setStrategyId(event.getDispatcher().getStrategyId());
        url = this.macrosHandler.replaceAll(url, attribute);
        if (log.isDebugEnabled()) {
            log.debug("dot mt {} url {}", (Object)43, (Object)url);
        }
        this.openLogClient.asyncRequest(url);
    }

    private MultiValueMap<String, String> buildCustomizeParams(List<FilterInfo> filterInfos) {
        boolean multiple = filterInfos.size() > 1;
        ArrayList entities = new ArrayList();
        for (FilterInfo filterInfo : filterInfos) {
            Bid bid = filterInfo.getBid();
            String adId = bid.getAdid();
            Map<Integer, Set<Long>> filterConfigMap = filterInfo.getFilterConfigMap();
            filterConfigMap.forEach((integer, longs) -> {
                FilterEntity filter = new FilterEntity();
                filter.setIds((Set<Long>)longs).setType((Integer)integer);
                if (multiple) {
                    filter.setAdid(adId);
                }
                entities.add(filter);
            });
        }
        LinkedMultiValueMap customizeParams = new LinkedMultiValueMap();
        customizeParams.add((Object)"dpcfil", (Object)UrlHelper.urlEncode((String)JsonHelper.convert(entities)));
        return customizeParams;
    }

    static class FilterEntity {
        private String adid;
        private Integer type;
        private Set<Long> ids;

        public String getAdid() {
            return this.adid;
        }

        public Integer getType() {
            return this.type;
        }

        public Set<Long> getIds() {
            return this.ids;
        }

        public FilterEntity setAdid(String adid) {
            this.adid = adid;
            return this;
        }

        public FilterEntity setType(Integer type) {
            this.type = type;
            return this;
        }

        public FilterEntity setIds(Set<Long> ids) {
            this.ids = ids;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterEntity)) {
                return false;
            }
            FilterEntity other = (FilterEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$type = this.getType();
            Integer other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            String this$adid = this.getAdid();
            String other$adid = other.getAdid();
            if (this$adid == null ? other$adid != null : !this$adid.equals(other$adid)) {
                return false;
            }
            Set<Long> this$ids = this.getIds();
            Set<Long> other$ids = other.getIds();
            return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FilterEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            String $adid = this.getAdid();
            result = result * 59 + ($adid == null ? 43 : $adid.hashCode());
            Set<Long> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            return result;
        }

        public String toString() {
            return "DotAdxDispatcherPriceConfigFilterEventListener.FilterEntity(adid=" + this.getAdid() + ", type=" + this.getType() + ", ids=" + this.getIds() + ")";
        }
    }
}

