/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.report;

import com.bxm.adx.common.adapter.AbstractPluginBuyModelAdapter;
import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.plugin.PluginHolder;
import com.bxm.adx.common.report.DspWinInfo;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DspWinPriceHandler {
    private static final Logger log = LoggerFactory.getLogger(DspWinPriceHandler.class);
    private final PluginHolder pluginHolder;

    public DspWinPriceHandler(PluginHolder pluginHolder) {
        this.pluginHolder = pluginHolder;
    }

    public DspWinInfo handle(BigDecimal price, Long dspId) {
        Buyer buyer = this.getBuyer(dspId);
        Dsp dsp = buyer.getDsp();
        String dspKey = dsp.getApiKey();
        BuyModelAdapter adapter = buyer.getModelAdapter();
        if (!(adapter instanceof AbstractPluginBuyModelAdapter)) {
            log.warn("unsupport adapter dsp-id {}", (Object)dsp);
            return null;
        }
        AbstractPluginBuyModelAdapter pluginAdapter = (AbstractPluginBuyModelAdapter)adapter;
        String macro = pluginAdapter.getPluginConfig().getProperties().getProperty("mwp");
        if (StringUtils.isBlank((CharSequence)macro)) {
            log.warn("marco is null dsp-id {}", (Object)dsp);
            return null;
        }
        BigDecimal dspWinPrice = pluginAdapter.priceScale(price);
        String cipher = pluginAdapter.encrypt(dspWinPrice.toString(), dspKey);
        if (StringUtils.isBlank((CharSequence)cipher)) {
            log.warn("cipher is null dsp-id {}", (Object)dsp);
            return null;
        }
        return DspWinInfo.builder().win(dspWinPrice).cipher(cipher).macro(macro).build();
    }

    private Buyer getBuyer(Long dspId) {
        Map<String, Buyer> buyers = this.pluginHolder.getBuyers();
        for (Map.Entry<String, Buyer> entry : buyers.entrySet()) {
            Buyer buyer = entry.getValue();
            Dsp dsp = buyer.getDsp();
            if (!Objects.nonNull(dsp) || !dsp.getId().equals(dspId)) continue;
            return buyer;
        }
        return null;
    }
}

