/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.report;

import com.bxm.adx.common.cipher.PriceCipher;
import com.bxm.adx.common.entity.DspPriceDotParam;
import com.bxm.adx.common.report.ReportType;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.utils.JsonHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportParam {
    private static final Logger log = LoggerFactory.getLogger(ReportParam.class);
    private String bidId;
    private String adId;
    private String chargeType;
    private Integer bidModel;
    private ReportType type;
    private String dspId;
    private String mediaId;
    private String appId;
    private String mediaWinPrice;
    private String advWinPriceModel;
    private String dspPriceConfig;

    public Integer getChargeType() {
        if (Objects.isNull(this.chargeType)) {
            return null;
        }
        return Integer.valueOf(this.chargeType);
    }

    public BigDecimal getDspWinPrice(String key) {
        if (StringUtils.isBlank((CharSequence)this.mediaWinPrice)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.advWinPriceModel)) {
            return null;
        }
        Integer model = Integer.valueOf(this.advWinPriceModel);
        if (1 == model) {
            DspPriceDotParam priceDotParam = null;
            try {
                priceDotParam = (DspPriceDotParam)JsonHelper.convert((String)PriceCipher.decryptWin(this.dspPriceConfig, key), DspPriceDotParam.class);
            }
            catch (Exception e) {
                log.error("err", (Throwable)e);
                throw new AdxException(AdxErrEnum.UNKNOWN_ERR);
            }
            BigDecimal win = new BigDecimal(this.mediaWinPrice);
            BigDecimal basePrice = null;
            switch (this.type) {
                case IMP: {
                    win = win.movePointRight(3);
                    win = win.movePointLeft(1);
                    basePrice = priceDotParam.getDprpre();
                    break;
                }
                case CLICK: {
                    win = win.movePointLeft(1);
                    basePrice = priceDotParam.getDpr();
                    break;
                }
                default: {
                    log.error("unknown type {}", (Object)this.type.name());
                    return null;
                }
            }
            BigDecimal mediaBaseWin = win.divide(new BigDecimal(100).subtract(priceDotParam.getPm()), RoundingMode.HALF_UP).movePointRight(2);
            if (mediaBaseWin.compareTo(basePrice) == 1) {
                return basePrice;
            }
            return mediaBaseWin;
        }
        return null;
    }

    public String toString() {
        return "ReportParam{bidId='" + this.bidId + '\'' + ", adId='" + this.adId + '\'' + ", chargeType='" + this.chargeType + '\'' + ", bidModel=" + this.bidModel + ", type=" + (Object)((Object)this.type) + ", dspId='" + this.dspId + '\'' + ", mediaId='" + this.mediaId + '\'' + ", appId='" + this.appId + '\'' + '}';
    }

    ReportParam(String bidId, String adId, String chargeType, Integer bidModel, ReportType type, String dspId, String mediaId, String appId, String mediaWinPrice, String advWinPriceModel, String dspPriceConfig) {
        this.bidId = bidId;
        this.adId = adId;
        this.chargeType = chargeType;
        this.bidModel = bidModel;
        this.type = type;
        this.dspId = dspId;
        this.mediaId = mediaId;
        this.appId = appId;
        this.mediaWinPrice = mediaWinPrice;
        this.advWinPriceModel = advWinPriceModel;
        this.dspPriceConfig = dspPriceConfig;
    }

    public static ReportParamBuilder builder() {
        return new ReportParamBuilder();
    }

    public String getBidId() {
        return this.bidId;
    }

    public String getAdId() {
        return this.adId;
    }

    public Integer getBidModel() {
        return this.bidModel;
    }

    public ReportType getType() {
        return this.type;
    }

    public String getDspId() {
        return this.dspId;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMediaWinPrice() {
        return this.mediaWinPrice;
    }

    public String getAdvWinPriceModel() {
        return this.advWinPriceModel;
    }

    public String getDspPriceConfig() {
        return this.dspPriceConfig;
    }

    public void setBidId(String bidId) {
        this.bidId = bidId;
    }

    public void setAdId(String adId) {
        this.adId = adId;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public void setBidModel(Integer bidModel) {
        this.bidModel = bidModel;
    }

    public void setType(ReportType type) {
        this.type = type;
    }

    public void setDspId(String dspId) {
        this.dspId = dspId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setMediaWinPrice(String mediaWinPrice) {
        this.mediaWinPrice = mediaWinPrice;
    }

    public void setAdvWinPriceModel(String advWinPriceModel) {
        this.advWinPriceModel = advWinPriceModel;
    }

    public void setDspPriceConfig(String dspPriceConfig) {
        this.dspPriceConfig = dspPriceConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportParam)) {
            return false;
        }
        ReportParam other = (ReportParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$bidModel = this.getBidModel();
        Integer other$bidModel = other.getBidModel();
        if (this$bidModel == null ? other$bidModel != null : !((Object)this$bidModel).equals(other$bidModel)) {
            return false;
        }
        String this$bidId = this.getBidId();
        String other$bidId = other.getBidId();
        if (this$bidId == null ? other$bidId != null : !this$bidId.equals(other$bidId)) {
            return false;
        }
        String this$adId = this.getAdId();
        String other$adId = other.getAdId();
        if (this$adId == null ? other$adId != null : !this$adId.equals(other$adId)) {
            return false;
        }
        Integer this$chargeType = this.getChargeType();
        Integer other$chargeType = other.getChargeType();
        if (this$chargeType == null ? other$chargeType != null : !((Object)this$chargeType).equals(other$chargeType)) {
            return false;
        }
        ReportType this$type = this.getType();
        ReportType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$dspId = this.getDspId();
        String other$dspId = other.getDspId();
        if (this$dspId == null ? other$dspId != null : !this$dspId.equals(other$dspId)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$mediaWinPrice = this.getMediaWinPrice();
        String other$mediaWinPrice = other.getMediaWinPrice();
        if (this$mediaWinPrice == null ? other$mediaWinPrice != null : !this$mediaWinPrice.equals(other$mediaWinPrice)) {
            return false;
        }
        String this$advWinPriceModel = this.getAdvWinPriceModel();
        String other$advWinPriceModel = other.getAdvWinPriceModel();
        if (this$advWinPriceModel == null ? other$advWinPriceModel != null : !this$advWinPriceModel.equals(other$advWinPriceModel)) {
            return false;
        }
        String this$dspPriceConfig = this.getDspPriceConfig();
        String other$dspPriceConfig = other.getDspPriceConfig();
        return !(this$dspPriceConfig == null ? other$dspPriceConfig != null : !this$dspPriceConfig.equals(other$dspPriceConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $bidModel = this.getBidModel();
        result = result * 59 + ($bidModel == null ? 43 : ((Object)$bidModel).hashCode());
        String $bidId = this.getBidId();
        result = result * 59 + ($bidId == null ? 43 : $bidId.hashCode());
        String $adId = this.getAdId();
        result = result * 59 + ($adId == null ? 43 : $adId.hashCode());
        Integer $chargeType = this.getChargeType();
        result = result * 59 + ($chargeType == null ? 43 : ((Object)$chargeType).hashCode());
        ReportType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $dspId = this.getDspId();
        result = result * 59 + ($dspId == null ? 43 : $dspId.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $mediaWinPrice = this.getMediaWinPrice();
        result = result * 59 + ($mediaWinPrice == null ? 43 : $mediaWinPrice.hashCode());
        String $advWinPriceModel = this.getAdvWinPriceModel();
        result = result * 59 + ($advWinPriceModel == null ? 43 : $advWinPriceModel.hashCode());
        String $dspPriceConfig = this.getDspPriceConfig();
        result = result * 59 + ($dspPriceConfig == null ? 43 : $dspPriceConfig.hashCode());
        return result;
    }

    public static class ReportParamBuilder {
        private String bidId;
        private String adId;
        private String chargeType;
        private Integer bidModel;
        private ReportType type;
        private String dspId;
        private String mediaId;
        private String appId;
        private String mediaWinPrice;
        private String advWinPriceModel;
        private String dspPriceConfig;

        ReportParamBuilder() {
        }

        public ReportParamBuilder bidId(String bidId) {
            this.bidId = bidId;
            return this;
        }

        public ReportParamBuilder adId(String adId) {
            this.adId = adId;
            return this;
        }

        public ReportParamBuilder chargeType(String chargeType) {
            this.chargeType = chargeType;
            return this;
        }

        public ReportParamBuilder bidModel(Integer bidModel) {
            this.bidModel = bidModel;
            return this;
        }

        public ReportParamBuilder type(ReportType type) {
            this.type = type;
            return this;
        }

        public ReportParamBuilder dspId(String dspId) {
            this.dspId = dspId;
            return this;
        }

        public ReportParamBuilder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public ReportParamBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public ReportParamBuilder mediaWinPrice(String mediaWinPrice) {
            this.mediaWinPrice = mediaWinPrice;
            return this;
        }

        public ReportParamBuilder advWinPriceModel(String advWinPriceModel) {
            this.advWinPriceModel = advWinPriceModel;
            return this;
        }

        public ReportParamBuilder dspPriceConfig(String dspPriceConfig) {
            this.dspPriceConfig = dspPriceConfig;
            return this;
        }

        public ReportParam build() {
            return new ReportParam(this.bidId, this.adId, this.chargeType, this.bidModel, this.type, this.dspId, this.mediaId, this.appId, this.mediaWinPrice, this.advWinPriceModel, this.dspPriceConfig);
        }

        public String toString() {
            return "ReportParam.ReportParamBuilder(bidId=" + this.bidId + ", adId=" + this.adId + ", chargeType=" + this.chargeType + ", bidModel=" + this.bidModel + ", type=" + (Object)((Object)this.type) + ", dspId=" + this.dspId + ", mediaId=" + this.mediaId + ", appId=" + this.appId + ", mediaWinPrice=" + this.mediaWinPrice + ", advWinPriceModel=" + this.advWinPriceModel + ", dspPriceConfig=" + this.dspPriceConfig + ")";
        }
    }
}

