/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.mapping;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.PositionMappingProperties;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionChangeHandler;
import com.bxm.adx.common.sell.position.mapping.PositionMappingStrategy;
import com.bxm.adx.common.sell.position.mapping.Strategy;
import com.bxm.adx.common.sell.request.Impression;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PositionTypeStrategy
implements PositionMappingStrategy,
PositionChangeHandler {
    private final AdxProperties adxProperties;
    private final ConcurrentHashMap<String, Position> positionTypeMap = new ConcurrentHashMap();

    public PositionTypeStrategy(AdxProperties adxProperties) {
        this.adxProperties = adxProperties;
    }

    @Override
    public Strategy strategy() {
        return Strategy.Position_type;
    }

    @Override
    public Position mapping(BidRequest bidRequest, Impression impression, PositionMappingProperties properties) {
        String appId = this.getAppId(bidRequest, properties);
        return this.getPositionByInfo(appId, impression.getImp_type());
    }

    public Position getPositionByInfo(String appId, Integer positionScene) {
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        if (Objects.isNull(positionScene)) {
            return null;
        }
        String key = this.buildMapKeyByPositionType(appId, positionScene);
        return this.positionTypeMap.get(key);
    }

    private String getAppId(BidRequest bidRequest, PositionMappingProperties properties) {
        return properties.getDefaultAppId();
    }

    @Override
    public void doUpdate(Position old, Position latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            Strategy strategy = this.getStrategy(latest);
            switch (strategy) {
                case Position_type: {
                    String infoKey = this.buildMapKeyByPositionType(latest);
                    if (!StringUtils.isNotEmpty((String)infoKey)) break;
                    this.positionTypeMap.put(infoKey, latest);
                }
            }
        }
    }

    @Override
    public void doDelete(Position old) {
        Strategy strategy = this.getStrategy(old);
        switch (strategy) {
            case Position_type: {
                String infoKey = this.buildMapKeyByPositionType(old);
                if (!StringUtils.isNotEmpty((String)infoKey)) break;
                this.positionTypeMap.remove(infoKey);
            }
        }
    }

    public String buildMapKeyByPositionType(Position position) {
        String appId = position.getAppId();
        Byte scene = position.getPositionScene();
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        if (Objects.isNull(scene)) {
            return null;
        }
        String val = appId + "-" + position.getPositionScene();
        return val;
    }

    public String buildMapKeyByPositionType(String appId, int positionScene) {
        String val = appId + "-" + positionScene;
        return val;
    }

    private Strategy getStrategy(Position position) {
        String appId = position.getAppId();
        List<PositionMappingProperties> positionMapping = this.adxProperties.getPositionMapping();
        if (CollectionUtils.isEmpty(positionMapping)) {
            return Strategy.Default;
        }
        for (PositionMappingProperties pm : positionMapping) {
            if (!appId.equals(pm.getAndroidAppId()) && !appId.equals(pm.getIosAppId()) && !appId.equals(pm.getDefaultAppId())) continue;
            return pm.getStrategy();
        }
        return Strategy.Default;
    }
}

