/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.model.dev.SdkInitCache;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.sifter.task.TaskChainData;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.adx.service.service.DevService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.sifter.AbstractSifterChain;
import com.bxm.warcar.integration.sifter.Context;
import com.bxm.warcar.utils.DateHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TaskSifterSupperChain
extends AbstractSifterChain {
    protected void handleParam(TaskInfoRequest request, List<TaskCache> list, TaskData data) {
        data.setRequest(request);
        TaskChainData chainData = new TaskChainData();
        data.setChainData(chainData);
        ArrayList<Long> idList = new ArrayList<Long>();
        list.forEach(info -> idList.add(info.getId()));
        chainData.setIds(idList);
        Date today = new Date();
        chainData.setToday(today);
        chainData.setTodayYmd(DateHelper.format((Date)today, (String)"yyyyMMdd"));
    }

    protected void fillGlobal(Fetcher fetcher, DevService devService, Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        TaskChainData chainData = data.getChainData();
        if (StringUtils.isNotEmpty((CharSequence)data.getRequest().getDevUid())) {
            SdkInitCache sdkCache = devService.getSdkInitByUid(data.getRequest().getDevUid());
            if (null != sdkCache && null != sdkCache.getDevb()) {
                chainData.setDevb(sdkCache.getDevb().toLowerCase());
            }
            if (Objects.equals(((TaskData)context.getData()).getRequest().getOs(), DevOsEnum.ANDROID.getId())) {
                chainData.setPkns(devService.getInstalledListByUid(data.getRequest().getDevUid()));
            }
        }
        Map mapGlobalConfig = fetcher.hfetchall(AdxKeyGenerator.getConfig(), String.class);
        chainData.setMapGlobalConfig(mapGlobalConfig);
        KeyGenerator keyGenerator = AdxKeyGenerator.Task.getCounterForDev((String)chainData.getTodayYmd(), (String)data.getRequest().getDevUid());
        Map mapDevCounterToday = fetcher.hfetchall(keyGenerator, String.class);
        chainData.setMapDevCounterToday(mapDevCounterToday);
    }

    protected void sort(List<TaskCache> list) {
        list.sort((o1, o2) -> {
            if (null == o1 || null == o1.getPriority()) {
                return 1;
            }
            if (null == o2 || null == o2.getPriority()) {
                return -1;
            }
            if (Objects.equals(o1.getPriority(), o2.getPriority())) {
                return o1.getId().compareTo(o2.getId());
            }
            return o1.getPriority().compareTo(o2.getPriority());
        });
    }
}

