/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.service.impl;

import com.bxm.adx.service.entity.ActivityPosInfo;
import com.bxm.adx.service.service.ActivitySceneService;
import com.bxm.mccms.facade.model.pushable.SceneSettingCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActivitySceneServiceImpl
implements ActivitySceneService {
    private static final Logger log = LoggerFactory.getLogger(ActivitySceneServiceImpl.class);
    private final Fetcher fetcher;
    private final ObjectMapper objectMapper;

    public ActivitySceneServiceImpl(Fetcher fetcher, ObjectMapper objectMapper) {
        this.fetcher = fetcher;
        this.objectMapper = objectMapper;
    }

    @Override
    public ActivityPosInfo getActivityPosInfo(String positionId, String activityId) {
        block5: {
            String positionConfig;
            SceneSettingCacheVO.SceneActivity sc;
            List activities;
            SceneSettingCacheVO cacheVO = this.getByPositionId(positionId);
            if (cacheVO != null && !CollectionUtils.isEmpty((Collection)(activities = cacheVO.getSceneActivities())) && (sc = (SceneSettingCacheVO.SceneActivity)activities.stream().filter(sceneActivity -> activityId.equals(sceneActivity.getActivityId())).findFirst().orElse(null)) != null && !StringUtils.isEmpty((Object)(positionConfig = sc.getPositionConfig()))) {
                try {
                    JsonNode json = this.objectMapper.readTree(positionConfig);
                    if (json != null && json.isArray()) {
                        ArrayList<ActivityPosInfo.PosInfo> posInfos = new ArrayList<ActivityPosInfo.PosInfo>();
                        for (JsonNode j : json) {
                            ActivityPosInfo.PosInfo posInfo = new ActivityPosInfo.PosInfo();
                            if (!j.has("positionId")) continue;
                            posInfo.setPositionId(j.get("positionId").toString());
                            if (!j.has("positionScene")) continue;
                            posInfo.setPositionScene(j.get("positionScene").intValue());
                            if (!j.has("id")) continue;
                            posInfo.setId(j.get("id").intValue());
                            if (!j.has("informationFlowTemplate")) continue;
                            posInfo.setInformationFlowTemplate(j.get("informationFlowTemplate").intValue());
                            posInfos.add(posInfo);
                        }
                        ActivityPosInfo activityPosInfo = new ActivityPosInfo();
                        activityPosInfo.setPosInfos(posInfos);
                        return activityPosInfo;
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error("err", (Throwable)e);
                }
            }
        }
        return null;
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "SCENE", "DSP", value});
    }

    private SceneSettingCacheVO getByPositionId(String positionId) {
        return (SceneSettingCacheVO)this.fetcher.fetch(this.getKeyGenerator(positionId), SceneSettingCacheVO.class);
    }
}

