/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.autoconfigure.redis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.AbstractSubscriberHandler;
import com.bxm.warcar.mq.redis.JedisPublisher;
import com.bxm.warcar.mq.redis.JedisSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@ConditionalOnClass(value={JedisPool.class, JedisConfiguration.class})
public class JedisBroadcastingAutoConfiguration
extends AbstractSubscriberHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisBroadcastingAutoConfiguration.class);
    private final JedisPool jedisPool;

    @Autowired
    public JedisBroadcastingAutoConfiguration(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Bean(initMethod="start", destroyMethod="close")
    public Producer jedisPublisher() {
        return new JedisPublisher(this.jedisPool);
    }

    @Override
    protected Consumer create(String consumerId, Listener messageListener) {
        if (!(messageListener instanceof SingleMessageListener)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("RedisConsumer's message listener must instance of #SingleMessageListener!");
            }
            return null;
        }
        return new JedisSubscriber(this.jedisPool, (SingleMessageListener)messageListener);
    }
}

