/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.api.adapter.wake;

import com.bxm.adx.service.common.api.adapter.wake.WakeAdapter;
import com.bxm.adx.service.common.api.adapter.wake.WakeCheckApiEnum;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class WakeAdapterFactory
implements ApplicationListener<ApplicationPreparedEvent> {
    private static final Map<Integer, WakeAdapter> ADAPTER_MAP = Maps.newConcurrentMap();

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map beansOfType = applicationContext.getBeansOfType(WakeAdapter.class);
        Set entries = beansOfType.entrySet();
        for (Map.Entry entry : entries) {
            WakeAdapter service = (WakeAdapter)entry.getValue();
            ADAPTER_MAP.put(service.getAdapterId().getValue(), service);
        }
    }

    public static WakeAdapter getAdapter(Integer wakeCheckApi) {
        return ADAPTER_MAP.get(wakeCheckApi);
    }

    public static WakeAdapter getAdapter(WakeCheckApiEnum wakeCheckApiEnum) {
        return ADAPTER_MAP.get(wakeCheckApiEnum.getValue());
    }

    public static Map<Integer, WakeAdapter> getAdApterMap() {
        return Collections.unmodifiableMap(ADAPTER_MAP);
    }
}

