/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.facade.rule.task.TaskDeviceBrandRuleSo;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskChainData;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class TaskDeviceBrandSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskDeviceBrandSifter.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public boolean filter(Context<TaskData> context) {
        if (StringUtils.isEmpty((String)((TaskData)context.getData()).getChainData().getDevb())) {
            return false;
        }
        this.fillDeviceBrand(context);
        return this.filterDeviceBrand(context);
    }

    private boolean filterDeviceBrand(Context<TaskData> context) {
        String devb = ((TaskData)context.getData()).getChainData().getDevb();
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        TaskDeviceBrandRuleSo rule = ((TaskData)context.getData()).getMapDeviceBrandRule().get(data.getId());
        if (null == rule || CollectionUtils.isEmpty(rule.getDeviceBrands())) {
            return false;
        }
        boolean blackList = rule.isBlackList();
        Set<String> list = rule.getDeviceBrands();
        if (blackList) {
            if (list.contains(devb)) {
                super.addReason(context, "\u5728\u8bbe\u5907\u54c1\u724c\u9ed1\u540d\u5355");
                return true;
            }
        } else if (!list.contains(devb)) {
            super.addReason(context, "\u4e0d\u5728\u8bbe\u5907\u54c1\u724c\u767d\u540d\u5355");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillDeviceBrand(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        TaskChainData chainData = data.getChainData();
        if (Boolean.TRUE.equals(data.getFlagDeviceBrand())) {
            return;
        }
        List<Long> ids = super.getIds(context);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HashMap<Long, TaskDeviceBrandRuleSo> mapDeviceBrandRule = new HashMap<Long, TaskDeviceBrandRuleSo>();
        data.setFlagDeviceBrand(Boolean.TRUE);
        data.setMapDeviceBrandRule(mapDeviceBrandRule);
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<String>> mapDeviceBrandRuleRs = new HashMap<Long, Response<String>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapDeviceBrandRuleRs.put(id, (Response<String>)pipeline.get(AdxKeyGenerator.Task.getDeviceBrandRule(id).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("fillDeviceBrand error: ids={},e={}", ids, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        this.fillDeviceBrand(mapDeviceBrandRule, mapDeviceBrandRuleRs);
    }

    private void fillDeviceBrand(Map<Long, TaskDeviceBrandRuleSo> mapDeviceBrandRule, Map<Long, Response<String>> mapDeviceBrandRuleRs) {
        Set<Long> keySet = mapDeviceBrandRuleRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapDeviceBrandRuleRs.get(id);
            String str = (String)strRs.get();
            if (StringUtils.isBlank((String)str)) continue;
            mapDeviceBrandRule.put(id, (TaskDeviceBrandRuleSo)JSON.parseObject((String)str, TaskDeviceBrandRuleSo.class));
        }
    }
}

