/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.facade.rule.task.TaskTimeSlotRuleSo;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskChainData;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class TaskTimeSlotSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskTimeSlotSifter.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public boolean filter(Context<TaskData> context) {
        this.fillTimeSlot(context);
        return this.filterTimeSlot(context);
    }

    private boolean filterTimeSlot(Context<TaskData> context) {
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        TaskTimeSlotRuleSo rule = ((TaskData)context.getData()).getMapTimeSlotRule().get(data.getId());
        if (null == rule || MapUtils.isEmpty(rule.getWeekTimeSlot())) {
            return false;
        }
        TaskChainData chainData = ((TaskData)context.getData()).getChainData();
        int weekDayIndex = this.getWeekDay(chainData.getToday()) - 1;
        Map<Integer, Boolean> timeSlot = rule.getWeekTimeSlot().get(weekDayIndex);
        if (MapUtils.isEmpty(timeSlot)) {
            return false;
        }
        int hours = chainData.getToday().getHours();
        Boolean flag = timeSlot.get(hours);
        if (null == flag || !flag.booleanValue()) {
            super.addReason(context, "\u4e0d\u5728\u6295\u653e\u65f6\u6bb5");
            return true;
        }
        return false;
    }

    private int getWeekDay(Date date) {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setTime(date);
        int days = cld.get(7);
        if (days == 1) {
            return 7;
        }
        return days - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTimeSlot(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        if (Boolean.TRUE.equals(data.getFlagTimeSlot())) {
            return;
        }
        List<Long> ids = super.getIds(context);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HashMap<Long, TaskTimeSlotRuleSo> mapTimeSlotRule = new HashMap<Long, TaskTimeSlotRuleSo>();
        data.setFlagTimeSlot(Boolean.TRUE);
        data.setMapTimeSlotRule(mapTimeSlotRule);
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<String>> mapTimeSlotRuleRs = new HashMap<Long, Response<String>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapTimeSlotRuleRs.put(id, (Response<String>)pipeline.get(AdxKeyGenerator.Task.getTimeSlotRule(id).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("fillTimeSlot error: ids={},e={}", ids, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        this.fillTimeSlot(mapTimeSlotRule, mapTimeSlotRuleRs);
    }

    private void fillTimeSlot(Map<Long, TaskTimeSlotRuleSo> mapTimeSlotRule, Map<Long, Response<String>> mapTimeSlotRuleRs) {
        Set<Long> keySet = mapTimeSlotRuleRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapTimeSlotRuleRs.get(id);
            String str = (String)strRs.get();
            if (StringUtils.isBlank((String)str)) continue;
            mapTimeSlotRule.put(id, (TaskTimeSlotRuleSo)JSON.parseObject((String)str, TaskTimeSlotRuleSo.class));
        }
    }
}

