/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.bxm.adx.facade.constant.enums.TaskTypeEnum;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.api.adapter.wake.WakeAdapterHandle;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.integration.sifter.Context;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskWakeAllowSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskWakeAllowSifter.class);
    @Autowired
    private WakeAdapterHandle wakeAdapterHandle;

    public boolean filter(Context<TaskData> context) {
        return this.filterWakeAllow(context);
    }

    private boolean filterWakeAllow(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        TaskCache taskCache = data.getTaskCache();
        if (!Objects.equals(taskCache.getType(), TaskTypeEnum.SILENCE_WAKE.getId())) {
            return false;
        }
        Integer wakeCheckApi = taskCache.getWakeCheckApi();
        if (null == wakeCheckApi || wakeCheckApi < 1) {
            return false;
        }
        Map<Integer, Boolean> mapWakeAllow = data.getMapWakeAllow();
        Boolean allow = mapWakeAllow.get(wakeCheckApi);
        if (null != allow) {
            if (!allow.booleanValue()) {
                super.addReason(context, "API\u4e0d\u8bb8\u53ef");
                return true;
            }
            return false;
        }
        TaskInfoRequest request = data.getRequest();
        allow = this.wakeAdapterHandle.isWakeUser(taskCache.getWakeCheckApi(), request);
        mapWakeAllow.put(wakeCheckApi, allow);
        if (!allow.booleanValue()) {
            super.addReason(context, "API\u4e0d\u8bb8\u53ef");
            return true;
        }
        return false;
    }
}

