package com.bxm.adx.timer.common;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/18 15:02
 */
public final class MediaEntranceCreativesBuider {

	/**
	 * 广告位素材流量比率 （每5 分钟更新一次）
	 * redis hash格式
	 * key-> ADX:POSITION:CREATIVES:FLOW:${广告位id}
	 * Map<String, Double>
	 */
	public static KeyGenerator flowRate(String positionId) {
		return () -> KeyBuilder.build("ADX", "POSITION","CREATIVES", "FLOW",positionId);
	}

	/**
	 * 广告位按日点击，曝光，点击率
	 * key-> AD:POSITION:PV:${date}
	 *  field->${广告位id}
	 * value {[]}
	 * @return
	 */
	public static KeyGenerator positionPrePv(String date) {
		return () -> KeyBuilder.build("ADX", "POSITION", "PV",date );
	}

	/**
	 * 广告位最近24小时点击率（点击/曝光）（每5 分钟更新一次）
	 * redis hash格式
	 * key-> ADX:POSITION:CLICKRATE:24H
	 * field->${广告位id}
	 * value
	 * @return  AD:POSITION:PV:24H
	 */
	public static KeyGenerator positionClickRate24H() {
		return () -> KeyBuilder.build("ADX", "POSITION", "CLICKRATE", "24H");
	}

	/**
	 * 广告位素材历史点击率（点击/曝光）（每5 分钟更新一次）
	 * redis hash格式
	 * key-> AD:POSITION:CLICKRATE:${广告位id}:ALL
	 * @return AD:POSITION:CLICKRATE:${广告位id}
	 */
	public static KeyGenerator clickRate(String positionId) {
		return () -> KeyBuilder.build("ADX", "POSITION", "CLICKRATE",positionId,"ALL");
	}

	/**
	 *广告位素材2H 点击,曝光,点击率。（每5分钟更新一次）
	 *key-> AD:POSITION:CLICKRATE:${广告位id}:2H
	 *field->${素材id}
	 *value {[]}
	 * @return AD:POSITION:CLICKRATE:${广告位id}
	 */
	public static KeyGenerator clickRate2H(String positionId) {
		return () -> KeyBuilder.build("ADX", "POSITION", "CLICKRATE",positionId,"2H");
	}

	/**
	 *广告位素材24H 点击,曝光,点击率。（每5分钟更新一次）
	 *key-> AD:POSITION:CLICKRATE:{广告位id}:24H
	 *field->${素材id}
	 *value {[]}
	 * @return AD:POSITION:CLICKRATE:${广告位id}
	 */
	public static KeyGenerator clickRate24H(String positionId) {
		return () -> KeyBuilder.build("ADX", "POSITION", "CLICKRATE",positionId,"24H");
	}

	/**
	 * 广告位下面所有开启的素材
	 * redis hash格式
	 * key-> ADX:POSITION:CREATIVES:ALL
	 * field->${素材id}
	 * value
	 */
	public static KeyGenerator positionAllCreatives() {
		return () -> KeyBuilder.build("ADX", "POSITION", "CREATIVES","ALL");
	}


}
