/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.RedisLock;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class DistributedRedisLock
implements RedisLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedRedisLock.class);
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    private static final Long UNLOCK_SUCCESS = 1L;
    private static final String SCRIPT = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    private final JedisPool jedisPool;
    private static final int DEFAULT_EXPIRETIME = 30000;

    public DistributedRedisLock(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(String key, String rid, int expireTime) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            String result = jedis.set(key, rid, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, expireTime);
            boolean bl = LOCK_SUCCESS.equals(result);
            return bl;
        }
        return false;
    }

    @Override
    public boolean tryLock(String key, String rid) {
        return this.tryLock(key, rid, 30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unLock(String key, String rid) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            Object result = jedis.eval(SCRIPT, Collections.singletonList(key), Collections.singletonList(rid));
            boolean bl = UNLOCK_SUCCESS.equals(result);
            return bl;
        }
        return false;
    }
}

