/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendException;
import com.bxm.warcar.mq.SendResult;
import com.bxm.warcar.mq.Type;
import com.bxm.warcar.mq.redis.RedisConst;
import com.bxm.warcar.utils.UUIDHelper;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisProducer
implements Producer {
    private final RedisTemplate<String, Message> redisTemplate;

    public RedisProducer(RedisTemplate<String, Message> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public SendResult send(Message message) throws SendException {
        String topic = message.getTopic();
        String id = UUIDHelper.generate();
        message.setMsgId(id);
        Long row = this.redisTemplate.opsForList().rightPush((Object)RedisConst.key(topic), (Object)message);
        if (null != row && row >= 1L) {
            return new SendResult(id);
        }
        throw new SendException("0");
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public Type getType() {
        return Type.Redis;
    }
}

