#!/bin/bash

ACTIVE="test"
if [ -z "$ACTIVE" ]; then
  ACTIVE="production"
  echo "Use default profile: $ACTIVE"
fi

[ ! -d ~/run/ ] && mkdir -p ~/run

if [ -f ~/run/adx-timer.pid ]; then
  echo "Server [adx-timer] pid file has been exists!";
  exit
fi

HEAP_MEMORY=256m
SERVER_JAR=`ls ../lib/adx-timer-2.1.16.jar`

exec "${JAVA_HOME}/bin/java" -server -Dspring.profiles.active=$ACTIVE -Xms${HEAP_MEMORY} -Xmx${HEAP_MEMORY} -XX:+HeapDumpOnOutOfMemoryError -jar ${SERVER_JAR} >/dev/null 2>&1 & echo $! > ~/run/adx-timer.pid