#!/bin/bash

if [ ! -f ~/run/adx-timer.pid ]; then
  echo "Server [adx-timer] doest not started!"
  exit
fi

pid=`cat ~/run/adx-timer.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adx-timer.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adx-timer] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adx-timer] cannot stop, Please check pid file 'adx-timer.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adx-timer] has been stoped!"
fi

rm -f ~/run/adx-timer.pid