/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.bxm;

import com.bxm.adx.common.AdxException;
import com.bxm.adx.common.adapter.AbstractFastjsonBuyModelAdapter;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.Native;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.plugins.bxm.BxmDirectPluginConfig;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BxmDirectBuyModelAdapter
extends AbstractFastjsonBuyModelAdapter {
    private static final Logger log = LoggerFactory.getLogger(BxmDirectBuyModelAdapter.class);
    @Autowired
    private DispatcherDao dispatcherDao;
    @Autowired
    private BxmDirectPluginConfig config;

    public byte[] buildRequest(BidRequest request) {
        List impressions = request.getImps();
        if (CollectionUtils.isEmpty((Collection)impressions)) {
            throw new AdxException("imps is null");
        }
        Impression impression = (Impression)impressions.get(0);
        if (impression == null) {
            throw new AdxException("imp is null");
        }
        if (request.getDevice() == null) {
            throw new AdxException("device is null");
        }
        Dispatcher dispatcher = this.dispatcherDao.get(impression.getTag_id(), this.config.getDspId().toString());
        String posId = dispatcher.getDspPosid();
        Request r = Request.builder().idfa(request.getDevice().getIdfa()).imei(request.getDevice().getImei()).ip(request.getDevice().getIp()).os(this.getOs(request)).position(posId).spm(RandomStringUtils.randomAlphabetic((int)32)).uid(this.getUid(request)).userAgent(request.getDevice().getUa()).activity("10").sspPositionId(impression.getTag_id()).build();
        return JsonHelper.convert2bytes((Object)r);
    }

    private int getOs(BidRequest request) {
        int os = 4;
        if ("IOS".equalsIgnoreCase(request.getDevice().getOs())) {
            os = 2;
        }
        if ("ANDROID".equalsIgnoreCase(request.getDevice().getOs())) {
            os = 1;
        }
        return os;
    }

    private String getUid(BidRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getDevice().getImei_md5())) {
            return request.getDevice().getImei_md5();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDevice().getIdfa_md5())) {
            return request.getDevice().getIdfa_md5();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDevice().getDpid_md5())) {
            return request.getDevice().getDpid_md5();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDevice().getImei())) {
            return DigestUtils.md5Hex((String)request.getDevice().getImei());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDevice().getIdfa())) {
            return DigestUtils.md5Hex((String)request.getDevice().getIdfa());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDevice().getDpid())) {
            return DigestUtils.md5Hex((String)request.getDevice().getDpid());
        }
        return UUIDHelper.generate();
    }

    public BidResponse buildResponse(byte[] r) {
        Response response = (Response)JsonHelper.convert((byte[])r, Response.class);
        Bid bid = new Bid();
        bid.setPrice(Float.valueOf(0.0f));
        bid.setTag_id(response.getSspPositionId());
        bid.setClick_through_url(response.getUrl());
        bid.setC_type(Integer.valueOf(6));
        ClickMonitor clickMonitor = new ClickMonitor();
        clickMonitor.setClick_monitor_url(response.getClickUrls().get(0));
        bid.setClick_monitors((List)Lists.newArrayList((Object[])new ClickMonitor[]{clickMonitor}));
        ImpMonitor impMonitor = new ImpMonitor();
        impMonitor.setImp_monitor_url(response.getImpUrls().get(0));
        bid.setImp_monitors((List)Lists.newArrayList((Object[])new ImpMonitor[]{impMonitor}));
        bid.setType(Integer.valueOf(2));
        bid.setCreate_id(response.getAssetsId());
        bid.setA_native(this.getNative(response));
        ArrayList bids = Lists.newArrayList();
        bids.add(bid);
        SeatBid seatBid = new SeatBid();
        seatBid.setDspId(this.config.getDspId());
        seatBid.setBid((List)bids);
        ArrayList seatBids = Lists.newArrayList();
        seatBids.add(seatBid);
        BidResponse bidResponse = new BidResponse();
        bidResponse.setSeat_bid((List)seatBids);
        bidResponse.setId(response.getResponseId());
        bidResponse.setTrack_id(response.getTicketId());
        return bidResponse;
    }

    private Native getNative(Response response) {
        Native na = new Native();
        ArrayList<Asset> assets = new ArrayList<Asset>();
        Asset asset = new Asset();
        asset.setId(response.getAssetsId());
        Image image = new Image();
        image.setUrl(response.getImgUrl());
        image.setH(response.getH());
        image.setW(response.getW());
        asset.setImg(image);
        asset.setRequired(Integer.valueOf(0));
        asset.setType(Integer.valueOf(7));
        assets.add(asset);
        na.setAssets(assets);
        return na;
    }

    private static class Response
    implements Serializable {
        private static final long serialVersionUID = -7214285500809757303L;
        private String responseId;
        private String ticketId;
        private String position;
        private String sspPositionId;
        private String url;
        private String uid;
        private int appos;
        private String imgUrl;
        private Integer w;
        private Integer h;
        private String assetsId;
        private List<String> impUrls;
        private List<String> clickUrls;

        Response(String responseId, String ticketId, String position, String sspPositionId, String url, String uid, int appos, String imgUrl, Integer w, Integer h, String assetsId, List<String> impUrls, List<String> clickUrls) {
            this.responseId = responseId;
            this.ticketId = ticketId;
            this.position = position;
            this.sspPositionId = sspPositionId;
            this.url = url;
            this.uid = uid;
            this.appos = appos;
            this.imgUrl = imgUrl;
            this.w = w;
            this.h = h;
            this.assetsId = assetsId;
            this.impUrls = impUrls;
            this.clickUrls = clickUrls;
        }

        public static ResponseBuilder builder() {
            return new ResponseBuilder();
        }

        private Response() {
        }

        public String getResponseId() {
            return this.responseId;
        }

        public String getTicketId() {
            return this.ticketId;
        }

        public String getPosition() {
            return this.position;
        }

        public String getSspPositionId() {
            return this.sspPositionId;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUid() {
            return this.uid;
        }

        public int getAppos() {
            return this.appos;
        }

        public String getImgUrl() {
            return this.imgUrl;
        }

        public Integer getW() {
            return this.w;
        }

        public Integer getH() {
            return this.h;
        }

        public String getAssetsId() {
            return this.assetsId;
        }

        public List<String> getImpUrls() {
            return this.impUrls;
        }

        public List<String> getClickUrls() {
            return this.clickUrls;
        }

        public void setResponseId(String responseId) {
            this.responseId = responseId;
        }

        public void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public void setSspPositionId(String sspPositionId) {
            this.sspPositionId = sspPositionId;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public void setAppos(int appos) {
            this.appos = appos;
        }

        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        public void setW(Integer w) {
            this.w = w;
        }

        public void setH(Integer h) {
            this.h = h;
        }

        public void setAssetsId(String assetsId) {
            this.assetsId = assetsId;
        }

        public void setImpUrls(List<String> impUrls) {
            this.impUrls = impUrls;
        }

        public void setClickUrls(List<String> clickUrls) {
            this.clickUrls = clickUrls;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$responseId = this.getResponseId();
            String other$responseId = other.getResponseId();
            if (this$responseId == null ? other$responseId != null : !this$responseId.equals(other$responseId)) {
                return false;
            }
            String this$ticketId = this.getTicketId();
            String other$ticketId = other.getTicketId();
            if (this$ticketId == null ? other$ticketId != null : !this$ticketId.equals(other$ticketId)) {
                return false;
            }
            String this$position = this.getPosition();
            String other$position = other.getPosition();
            if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
                return false;
            }
            String this$sspPositionId = this.getSspPositionId();
            String other$sspPositionId = other.getSspPositionId();
            if (this$sspPositionId == null ? other$sspPositionId != null : !this$sspPositionId.equals(other$sspPositionId)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$uid = this.getUid();
            String other$uid = other.getUid();
            if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
                return false;
            }
            if (this.getAppos() != other.getAppos()) {
                return false;
            }
            String this$imgUrl = this.getImgUrl();
            String other$imgUrl = other.getImgUrl();
            if (this$imgUrl == null ? other$imgUrl != null : !this$imgUrl.equals(other$imgUrl)) {
                return false;
            }
            Integer this$w = this.getW();
            Integer other$w = other.getW();
            if (this$w == null ? other$w != null : !((Object)this$w).equals(other$w)) {
                return false;
            }
            Integer this$h = this.getH();
            Integer other$h = other.getH();
            if (this$h == null ? other$h != null : !((Object)this$h).equals(other$h)) {
                return false;
            }
            String this$assetsId = this.getAssetsId();
            String other$assetsId = other.getAssetsId();
            if (this$assetsId == null ? other$assetsId != null : !this$assetsId.equals(other$assetsId)) {
                return false;
            }
            List<String> this$impUrls = this.getImpUrls();
            List<String> other$impUrls = other.getImpUrls();
            if (this$impUrls == null ? other$impUrls != null : !((Object)this$impUrls).equals(other$impUrls)) {
                return false;
            }
            List<String> this$clickUrls = this.getClickUrls();
            List<String> other$clickUrls = other.getClickUrls();
            return !(this$clickUrls == null ? other$clickUrls != null : !((Object)this$clickUrls).equals(other$clickUrls));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $responseId = this.getResponseId();
            result = result * 59 + ($responseId == null ? 43 : $responseId.hashCode());
            String $ticketId = this.getTicketId();
            result = result * 59 + ($ticketId == null ? 43 : $ticketId.hashCode());
            String $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            String $sspPositionId = this.getSspPositionId();
            result = result * 59 + ($sspPositionId == null ? 43 : $sspPositionId.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $uid = this.getUid();
            result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
            result = result * 59 + this.getAppos();
            String $imgUrl = this.getImgUrl();
            result = result * 59 + ($imgUrl == null ? 43 : $imgUrl.hashCode());
            Integer $w = this.getW();
            result = result * 59 + ($w == null ? 43 : ((Object)$w).hashCode());
            Integer $h = this.getH();
            result = result * 59 + ($h == null ? 43 : ((Object)$h).hashCode());
            String $assetsId = this.getAssetsId();
            result = result * 59 + ($assetsId == null ? 43 : $assetsId.hashCode());
            List<String> $impUrls = this.getImpUrls();
            result = result * 59 + ($impUrls == null ? 43 : ((Object)$impUrls).hashCode());
            List<String> $clickUrls = this.getClickUrls();
            result = result * 59 + ($clickUrls == null ? 43 : ((Object)$clickUrls).hashCode());
            return result;
        }

        public String toString() {
            return "BxmDirectBuyModelAdapter.Response(responseId=" + this.getResponseId() + ", ticketId=" + this.getTicketId() + ", position=" + this.getPosition() + ", sspPositionId=" + this.getSspPositionId() + ", url=" + this.getUrl() + ", uid=" + this.getUid() + ", appos=" + this.getAppos() + ", imgUrl=" + this.getImgUrl() + ", w=" + this.getW() + ", h=" + this.getH() + ", assetsId=" + this.getAssetsId() + ", impUrls=" + this.getImpUrls() + ", clickUrls=" + this.getClickUrls() + ")";
        }

        public static class ResponseBuilder {
            private String responseId;
            private String ticketId;
            private String position;
            private String sspPositionId;
            private String url;
            private String uid;
            private int appos;
            private String imgUrl;
            private Integer w;
            private Integer h;
            private String assetsId;
            private List<String> impUrls;
            private List<String> clickUrls;

            ResponseBuilder() {
            }

            public ResponseBuilder responseId(String responseId) {
                this.responseId = responseId;
                return this;
            }

            public ResponseBuilder ticketId(String ticketId) {
                this.ticketId = ticketId;
                return this;
            }

            public ResponseBuilder position(String position) {
                this.position = position;
                return this;
            }

            public ResponseBuilder sspPositionId(String sspPositionId) {
                this.sspPositionId = sspPositionId;
                return this;
            }

            public ResponseBuilder url(String url) {
                this.url = url;
                return this;
            }

            public ResponseBuilder uid(String uid) {
                this.uid = uid;
                return this;
            }

            public ResponseBuilder appos(int appos) {
                this.appos = appos;
                return this;
            }

            public ResponseBuilder imgUrl(String imgUrl) {
                this.imgUrl = imgUrl;
                return this;
            }

            public ResponseBuilder w(Integer w) {
                this.w = w;
                return this;
            }

            public ResponseBuilder h(Integer h) {
                this.h = h;
                return this;
            }

            public ResponseBuilder assetsId(String assetsId) {
                this.assetsId = assetsId;
                return this;
            }

            public ResponseBuilder impUrls(List<String> impUrls) {
                this.impUrls = impUrls;
                return this;
            }

            public ResponseBuilder clickUrls(List<String> clickUrls) {
                this.clickUrls = clickUrls;
                return this;
            }

            public Response build() {
                return new Response(this.responseId, this.ticketId, this.position, this.sspPositionId, this.url, this.uid, this.appos, this.imgUrl, this.w, this.h, this.assetsId, this.impUrls, this.clickUrls);
            }

            public String toString() {
                return "BxmDirectBuyModelAdapter.Response.ResponseBuilder(responseId=" + this.responseId + ", ticketId=" + this.ticketId + ", position=" + this.position + ", sspPositionId=" + this.sspPositionId + ", url=" + this.url + ", uid=" + this.uid + ", appos=" + this.appos + ", imgUrl=" + this.imgUrl + ", w=" + this.w + ", h=" + this.h + ", assetsId=" + this.assetsId + ", impUrls=" + this.impUrls + ", clickUrls=" + this.clickUrls + ")";
            }
        }
    }

    private static class Request
    implements Serializable {
        private static final long serialVersionUID = -7019148541208983560L;
        private String position;
        private String imei;
        private String idfa;
        private String ip;
        private int os;
        private String activity;
        private String userAgent;
        private String uid;
        private String spm;
        private String sspPositionId;

        Request(String position, String imei, String idfa, String ip, int os, String activity, String userAgent, String uid, String spm, String sspPositionId) {
            this.position = position;
            this.imei = imei;
            this.idfa = idfa;
            this.ip = ip;
            this.os = os;
            this.activity = activity;
            this.userAgent = userAgent;
            this.uid = uid;
            this.spm = spm;
            this.sspPositionId = sspPositionId;
        }

        public static RequestBuilder builder() {
            return new RequestBuilder();
        }

        private Request() {
        }

        public String getPosition() {
            return this.position;
        }

        public String getImei() {
            return this.imei;
        }

        public String getIdfa() {
            return this.idfa;
        }

        public String getIp() {
            return this.ip;
        }

        public int getOs() {
            return this.os;
        }

        public String getActivity() {
            return this.activity;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getUid() {
            return this.uid;
        }

        public String getSpm() {
            return this.spm;
        }

        public String getSspPositionId() {
            return this.sspPositionId;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }

        public void setIdfa(String idfa) {
            this.idfa = idfa;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setOs(int os) {
            this.os = os;
        }

        public void setActivity(String activity) {
            this.activity = activity;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public void setSpm(String spm) {
            this.spm = spm;
        }

        public void setSspPositionId(String sspPositionId) {
            this.sspPositionId = sspPositionId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$position = this.getPosition();
            String other$position = other.getPosition();
            if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
                return false;
            }
            String this$imei = this.getImei();
            String other$imei = other.getImei();
            if (this$imei == null ? other$imei != null : !this$imei.equals(other$imei)) {
                return false;
            }
            String this$idfa = this.getIdfa();
            String other$idfa = other.getIdfa();
            if (this$idfa == null ? other$idfa != null : !this$idfa.equals(other$idfa)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            if (this.getOs() != other.getOs()) {
                return false;
            }
            String this$activity = this.getActivity();
            String other$activity = other.getActivity();
            if (this$activity == null ? other$activity != null : !this$activity.equals(other$activity)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
                return false;
            }
            String this$uid = this.getUid();
            String other$uid = other.getUid();
            if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
                return false;
            }
            String this$spm = this.getSpm();
            String other$spm = other.getSpm();
            if (this$spm == null ? other$spm != null : !this$spm.equals(other$spm)) {
                return false;
            }
            String this$sspPositionId = this.getSspPositionId();
            String other$sspPositionId = other.getSspPositionId();
            return !(this$sspPositionId == null ? other$sspPositionId != null : !this$sspPositionId.equals(other$sspPositionId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            String $imei = this.getImei();
            result = result * 59 + ($imei == null ? 43 : $imei.hashCode());
            String $idfa = this.getIdfa();
            result = result * 59 + ($idfa == null ? 43 : $idfa.hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            result = result * 59 + this.getOs();
            String $activity = this.getActivity();
            result = result * 59 + ($activity == null ? 43 : $activity.hashCode());
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            String $uid = this.getUid();
            result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
            String $spm = this.getSpm();
            result = result * 59 + ($spm == null ? 43 : $spm.hashCode());
            String $sspPositionId = this.getSspPositionId();
            result = result * 59 + ($sspPositionId == null ? 43 : $sspPositionId.hashCode());
            return result;
        }

        public String toString() {
            return "BxmDirectBuyModelAdapter.Request(position=" + this.getPosition() + ", imei=" + this.getImei() + ", idfa=" + this.getIdfa() + ", ip=" + this.getIp() + ", os=" + this.getOs() + ", activity=" + this.getActivity() + ", userAgent=" + this.getUserAgent() + ", uid=" + this.getUid() + ", spm=" + this.getSpm() + ", sspPositionId=" + this.getSspPositionId() + ")";
        }

        public static class RequestBuilder {
            private String position;
            private String imei;
            private String idfa;
            private String ip;
            private int os;
            private String activity;
            private String userAgent;
            private String uid;
            private String spm;
            private String sspPositionId;

            RequestBuilder() {
            }

            public RequestBuilder position(String position) {
                this.position = position;
                return this;
            }

            public RequestBuilder imei(String imei) {
                this.imei = imei;
                return this;
            }

            public RequestBuilder idfa(String idfa) {
                this.idfa = idfa;
                return this;
            }

            public RequestBuilder ip(String ip) {
                this.ip = ip;
                return this;
            }

            public RequestBuilder os(int os) {
                this.os = os;
                return this;
            }

            public RequestBuilder activity(String activity) {
                this.activity = activity;
                return this;
            }

            public RequestBuilder userAgent(String userAgent) {
                this.userAgent = userAgent;
                return this;
            }

            public RequestBuilder uid(String uid) {
                this.uid = uid;
                return this;
            }

            public RequestBuilder spm(String spm) {
                this.spm = spm;
                return this;
            }

            public RequestBuilder sspPositionId(String sspPositionId) {
                this.sspPositionId = sspPositionId;
                return this;
            }

            public Request build() {
                return new Request(this.position, this.imei, this.idfa, this.ip, this.os, this.activity, this.userAgent, this.uid, this.spm, this.sspPositionId);
            }

            public String toString() {
                return "BxmDirectBuyModelAdapter.Request.RequestBuilder(position=" + this.position + ", imei=" + this.imei + ", idfa=" + this.idfa + ", ip=" + this.ip + ", os=" + this.os + ", activity=" + this.activity + ", userAgent=" + this.userAgent + ", uid=" + this.uid + ", spm=" + this.spm + ", sspPositionId=" + this.sspPositionId + ")";
            }
        }
    }
}

