package com.bxm.adx.plugins.deeplink.common;

import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import com.google.common.collect.Lists;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.List;

/**
 * @author allen
 * @date 2020-10-30
 * @since 1.0
 */
public abstract class AbstractDeepLinkPluginConfig implements PluginConfigAware {

    protected PluginConfig config;
    protected List<ImageConfig> imageConfigs = Lists.newArrayList();

    public AbstractDeepLinkPluginConfig() {
        imageConfigs.add(ImageConfig.builder().id("2334").url("https://image.bianxianmao.com/2020/11/03/ssp/1732fb7a38c844b4961e19b2b8c4c5b7.gif").build());
        imageConfigs.add(ImageConfig.builder().id("2335").url("https://image.bianxianmao.com/2020/11/03/ssp/83547a3e5990419d9514a03f7fc96c55.gif").build());
        imageConfigs.add(ImageConfig.builder().id("2336").url("https://image.bianxianmao.com/2020/11/03/ssp/f07b76574a964f3088c499c9cd530724.gif").build());
    }

    public String getKey() {
        return config.getKey();
    }

    /**
     * 随机一个图片素材
     * @return 图片素材。{@code key} 素材ID，{@code value} 素材地址
     */
    public ImageConfig randomImage() {
        int i = RandomUtils.nextInt(0, imageConfigs.size());
        return imageConfigs.get(i);
    }

    /**
     * 获取必须安装应用包名
     * @return app package name
     */
    public String getInstalledNeededApp() {
        return config.getProperties().getProperty("installedNeededApp");
    }

    public String getDeeplink() {
        return config.getProperties().getProperty("deeplink");
    }

    public int getLimitingShowPerDayOfUser() {
        return NumberUtils.toInt(config.getProperties().getProperty("limitingClickPerDayOfUser"), 3);
    }

    @Override
    public void setPluginConfig(PluginConfig pluginConfig) {
        this.config = pluginConfig;
    }

    @Data
    @Builder
    public static class ImageConfig {

        private String id;
        private String url;
    }
}
