package com.bxm.adx.plugins.deeplink.common.filter;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.plugins.deeplink.common.AbstractDeepLinkPluginConfig;
import com.bxm.adx.plugins.deeplink.common.RequestFilter;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * @author allen
 * @date 2020-10-27
 * @since 1.0
 */
public abstract class AbstractInstalledAppFilter implements RequestFilter {

    protected abstract AbstractDeepLinkPluginConfig getConfig();

    @Override
    public boolean abort(BidRequest request, List<String> installedApkList, Dsp dsp) {
        if (CollectionUtils.isEmpty(installedApkList)) {
            return false;
        }
        return !installedApkList.contains(getConfig().getInstalledNeededApp());
    }
}
