package com.bxm.adx.plugins.deeplink.common.filter;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.plugins.deeplink.common.RequestFilter;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;

import java.util.List;
import java.util.Optional;

/**
 * @author allen
 * @date 2020-10-30
 * @since 1.0
 */
public abstract class AbstractUserClickLimitingPerDayFilter implements RequestFilter {

    protected abstract Counter getCounter();

    @Override
    public boolean abort(BidRequest request, List<String> installedApkList, Dsp dsp) {
        Long dspId = dsp.getId();
        String uid = getUid(request.getDevice());
        List<Impression> imps = request.getImps();
        for (Impression imp : imps) {
            String positionId = imp.getTag_id();
            KeyGenerator key = () -> KeyBuilder.build("statistics", "adx", "click", DateHelper.getDate(), positionId, dspId, uid);
            boolean above = Optional.ofNullable(getCounter().get(key)).orElse(0L) >= 1;
            if (above) {
                return true;
            }
        }
        return false;
    }

    private String getUid(Device device) {
        return getFirstNotBlankOnArguments(device.getImei(), device.getIdfa(), device.getIdfa());
    }

    /**
     * 从传参列表取第一个非空的值
     * @return 有可能 null
     */
    private static String getFirstNotBlankOnArguments(String...values) {
        for (String value : values) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(value)) {
                return value;
            }
        }
        return null;
    }
}
