/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.deeplink.common;

import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractDeepLinkPluginConfig
implements PluginConfigAware {
    protected PluginConfig config;
    protected List<ImageConfig> imageConfigs = Lists.newArrayList();

    public AbstractDeepLinkPluginConfig() {
        this.imageConfigs.add(ImageConfig.builder().id("2334").url("https://image.bianxianmao.com/2020/11/03/ssp/1732fb7a38c844b4961e19b2b8c4c5b7.gif").build());
        this.imageConfigs.add(ImageConfig.builder().id("2335").url("https://image.bianxianmao.com/2020/11/03/ssp/83547a3e5990419d9514a03f7fc96c55.gif").build());
        this.imageConfigs.add(ImageConfig.builder().id("2336").url("https://image.bianxianmao.com/2020/11/03/ssp/f07b76574a964f3088c499c9cd530724.gif").build());
    }

    public String getKey() {
        return this.config.getKey();
    }

    public ImageConfig randomImage() {
        int i = RandomUtils.nextInt((int)0, (int)this.imageConfigs.size());
        return this.imageConfigs.get(i);
    }

    public String getInstalledNeededApp() {
        return this.config.getProperties().getProperty("installedNeededApp");
    }

    public String getDeeplink() {
        return this.config.getProperties().getProperty("deeplink");
    }

    public int getLimitingShowPerDayOfUser() {
        return NumberUtils.toInt((String)this.config.getProperties().getProperty("limitingClickPerDayOfUser"), (int)3);
    }

    public void setPluginConfig(PluginConfig pluginConfig) {
        this.config = pluginConfig;
    }

    public static class ImageConfig {
        private String id;
        private String url;

        ImageConfig(String id, String url) {
            this.id = id;
            this.url = url;
        }

        public static ImageConfigBuilder builder() {
            return new ImageConfigBuilder();
        }

        private ImageConfig() {
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageConfig)) {
                return false;
            }
            ImageConfig other = (ImageConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractDeepLinkPluginConfig.ImageConfig(id=" + this.getId() + ", url=" + this.getUrl() + ")";
        }

        public static class ImageConfigBuilder {
            private String id;
            private String url;

            ImageConfigBuilder() {
            }

            public ImageConfigBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ImageConfigBuilder url(String url) {
                this.url = url;
                return this;
            }

            public ImageConfig build() {
                return new ImageConfig(this.id, this.url);
            }

            public String toString() {
                return "AbstractDeepLinkPluginConfig.ImageConfig.ImageConfigBuilder(id=" + this.id + ", url=" + this.url + ")";
            }
        }
    }
}

