/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.deeplink.common.filter;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.plugins.deeplink.common.RequestFilter;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

public abstract class AbstractRequestFilterChain
implements RequestFilter,
BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestFilterChain.class);
    private List<RequestFilter> filters = Lists.newArrayList();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RequestFilter && !ClassUtils.getUserClass((Object)bean).equals(this.getClass())) {
            log.info("Registering filter to chain: {}", bean);
            this.filters.add((RequestFilter)bean);
        }
        return bean;
    }

    @Override
    public boolean abort(BidRequest request, List<String> installedApkList, Dsp dsp) {
        for (RequestFilter filter : this.filters) {
            boolean abort = filter.abort(request, installedApkList, dsp);
            if (!abort) continue;
            return true;
        }
        return false;
    }

    @Override
    public void afterCompletion(BidRequest request) {
        for (RequestFilter filter : this.filters) {
            try {
                filter.afterCompletion(request);
            }
            catch (Exception exception) {}
        }
    }
}

