/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.deeplink.common.filter;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.plugins.deeplink.common.RequestFilter;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractUserClickLimitingPerDayFilter
implements RequestFilter {
    protected abstract Counter getCounter();

    @Override
    public boolean abort(BidRequest request, List<String> installedApkList, Dsp dsp) {
        Long dspId = dsp.getId();
        String uid = this.getUid(request.getDevice());
        List imps = request.getImps();
        for (Impression imp : imps) {
            String positionId = imp.getTag_id();
            KeyGenerator key = () -> KeyBuilder.build((Object[])new Object[]{"statistics", "adx", "click", DateHelper.getDate(), positionId, dspId, uid});
            boolean above = Optional.ofNullable(this.getCounter().get(key)).orElse(0L) >= 1L;
            if (!above) continue;
            return true;
        }
        return false;
    }

    private String getUid(Device device) {
        return AbstractUserClickLimitingPerDayFilter.getFirstNotBlankOnArguments(device.getImei(), device.getIdfa(), device.getIdfa());
    }

    private static String getFirstNotBlankOnArguments(String ... values) {
        for (String value : values) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return value;
        }
        return null;
    }
}

