package com.bxm.adx.plugins.deeplink.common;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.warcar.utils.JsonHelper;

/**
 * @author allen
 * @date 2020-10-30
 * @since 1.0
 */
public abstract class AbstractDeepLinkBuyModelAdapter implements BuyModelAdapter {
    @Override
    public byte[] buildRequest(BidRequest request) {
        return JsonHelper.convert2bytes(request);
    }

    @Override
    public BidResponse buildResponse(byte[] response) {
        return JsonHelper.convert(response, BidResponse.class);
    }
}
