package com.bxm.adx.plugins.deeplink.common;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.buyer.AbstractBuyer;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.*;
import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.facade.service.UserService;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author allen
 * @date 2020-10-30
 * @since 1.0
 */
public abstract class AbstractDeepLinkBuyer extends AbstractBuyer {

    private final AbstractDeepLinkPluginConfig config;
    private final AbstractDeepLinkBuyModelAdapter buyModelAdapter;
    private final UserService userService;
    private final RequestFilter requestFilter;


    public AbstractDeepLinkBuyer(AbstractDeepLinkPluginConfig config,
                                 AbstractDeepLinkBuyModelAdapter buyModelAdapter,
                                 UserService userService,
                                 RequestFilter requestFilter) {
        this.config = config;
        this.buyModelAdapter = buyModelAdapter;
        this.userService = userService;
        this.requestFilter = requestFilter;
    }

    @Override
    protected byte[] request(byte[] requestBody) {
        BidRequest request = JsonHelper.convert(requestBody, BidRequest.class);
        Device device = request.getDevice();

        DevRequest.DevRequestBuilder builder = DevRequest.builder();
        builder.os(getOs(device.getOs()))
                .imei(device.getImei()).imeiMd5(device.getImei_md5())
                .anid(device.getDpid()).anidMd5(device.getDpid_md5())
                .idfa(device.getIdfa()).idfaMd5(device.getIdfa_md5());
        List<String> appList = userService.getInstalledList(builder.build());

        Dsp dsp = getDsp();
        if (requestFilter.abort(request, appList, dsp)) {
            return null;
        }

        BidResponse response = new BidResponse();

        List<SeatBid> seatBids = Lists.newArrayList();
        response.setSeat_bid(seatBids);

        List<Impression> imps = request.getImps();
        for (Impression imp : imps) {
            // 分解请求的广告位
            SeatBid seatBid = new SeatBid().setDspId(getDsp().getId());
            seatBids.add(seatBid);

            List<Bid> bids = new ArrayList<>();
            Bid bid = new Bid()
                    .setPrice(0F)
                    .setC_type(9)
                    .setType(2)
                    .setTag_id(imp.getTag_id())
                    .setImp_id(imp.getId())
                    .setDeep_link_url(config.getDeeplink());

            Native nt = new Native();
            List<Asset> assets = new ArrayList<>();

            AbstractDeepLinkPluginConfig.ImageConfig image = config.randomImage();

            Asset asset = new Asset()
                    .setId(image.getId())
                    .setType(7)
                    .setImg(new Image().setUrl(image.getUrl()));

            assets.add(asset);
            nt.setAssets(assets);
            bid.setCreate_id(image.getId());
            bid.setA_native(nt);
            bids.add(bid);

            seatBid.setBid(bids);
        }

        requestFilter.afterCompletion(request);

        return JsonHelper.convert2bytes(response);
    }

    @Override
    public String getCode() {
        return config.getKey();
    }

    @Override
    public BuyModelAdapter getModelAdapter() {
        return buyModelAdapter;
    }

    private int getOs(String os) {
        if (StringUtils.isBlank(os)) {
            return 0;
        }
        return StringUtils.equalsIgnoreCase(os, "ios") ? 2 :
                StringUtils.equalsIgnoreCase(os, "android") ? 1 : 0;
    }
}
