package com.bxm.adx.plugins.deeplink.common;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;

import java.util.List;

/**
 * 用户过滤器
 *
 * @author allen
 * @date 2020-10-27
 * @since 1.0
 */
public interface RequestFilter {

    /**
     * 当前流量是否直接终止投放
     * @param request 请求
     * @param installedApkList 已安装的APP列表
     * @param dsp DSP
     * @return 如果返回 true 那么终止投放
     */
    boolean abort(BidRequest request, List<String> installedApkList, Dsp dsp);

    /**
     * 过滤完成后，处理的操作
     * @param request 请求
     */
    default void afterCompletion(BidRequest request) {}
}
