package com.bxm.adx.plugins.deeplink.common.filter;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.plugins.deeplink.common.RequestFilter;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

import java.util.List;

/**
 * @author allen
 * @date 2020-10-28
 * @since 1.0
 */
@Slf4j
public abstract class AbstractRequestFilterChain implements RequestFilter, BeanPostProcessor {

    private List<RequestFilter> filters = Lists.newArrayList();

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RequestFilter) {
            if (!ClassUtils.getUserClass(bean).equals(this.getClass())) {
                log.info("Registering filter to chain: {}", bean);
                filters.add((RequestFilter) bean);
            }
        }
        return bean;
    }

    @Override
    public boolean abort(BidRequest request, List<String> installedApkList, Dsp dsp) {
        for (RequestFilter filter : filters) {
            boolean abort = filter.abort(request, installedApkList, dsp);
            if (abort) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void afterCompletion(BidRequest request) {
        for (RequestFilter filter : filters) {
            try {
                filter.afterCompletion(request);
            } catch (Exception ignored) {
            }
        }
    }
}
