/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.jincheng;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.PositionSceneTypeEnum;
import org.springframework.util.StringUtils;

public class JcConstant {

    public static enum Adt {
        BANNER(1),
        KAI_PING(2),
        CHA_PING(3),
        NATIVE(6),
        VIDEO(7);

        private int adt;

        private Adt(int adt) {
            this.adt = adt;
        }

        public int getAdt() {
            return this.adt;
        }

        public static Integer getAdt(int posScene) {
            PositionSceneTypeEnum sceneTypeEnum = PositionSceneTypeEnum.get((Integer)posScene);
            if (null == sceneTypeEnum) {
                return null;
            }
            switch (sceneTypeEnum) {
                case BANNER: {
                    return BANNER.getAdt();
                }
                case INSPIRE_VIDEO: {
                    return VIDEO.getAdt();
                }
                case BOOT: {
                    return KAI_PING.getAdt();
                }
                case SCREEN: {
                    return CHA_PING.getAdt();
                }
                case INFORMATION_FLOW: {
                    return NATIVE.getAdt();
                }
            }
            return null;
        }
    }

    public static enum Act {
        WEB_VIEW(2),
        DIRECT_DOWNLOAD(3),
        DOWNLOAD(4);

        private int act;

        private Act(int act) {
            this.act = act;
        }

        public int getAct() {
            return this.act;
        }
    }

    static class DeepLinkType {
        public static final Integer NO = 0;
        public static final Integer TYPE_1 = 1;
        public static final Integer TYPE_2 = 2;

        DeepLinkType() {
        }
    }

    public static enum AT {
        IMAGE(1),
        NATIVE(2),
        TEXT(3),
        HTML(5),
        VIDEO(7);

        private Integer at;

        private AT(Integer at) {
            this.at = at;
        }

        public static AdxConstants.Type getAdxBidType(Integer at) {
            if (at == null) {
                return null;
            }
            if (at == AT.IMAGE.at) {
                return AdxConstants.Type.IMAGE;
            }
            if (at == AT.NATIVE.at) {
                return AdxConstants.Type.NATIVE;
            }
            if (at == AT.VIDEO.at) {
                return AdxConstants.Type.VIDEO;
            }
            return null;
        }
    }

    public static enum OS {
        ANDROID(0),
        IOS(1),
        WP(2),
        OTHER(3);

        private int os;

        private OS(int os) {
            this.os = os;
        }

        public static Integer getOs(String os) {
            if (StringUtils.isEmpty((Object)os)) {
                return OS.OTHER.os;
            }
            if (os.equalsIgnoreCase(ANDROID.name())) {
                return OS.ANDROID.os;
            }
            if (os.equalsIgnoreCase(IOS.name())) {
                return OS.IOS.os;
            }
            if (os.equalsIgnoreCase(WP.name())) {
                return OS.WP.os;
            }
            return OS.OTHER.os;
        }
    }
}

