/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.jincheng;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.adapter.AbstractFastjsonBuyModelAdapter;
import com.bxm.adx.common.buy.BuyRequest;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionDao;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.AppMonitor;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.Native;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.response.Text;
import com.bxm.adx.common.sell.response.Video;
import com.bxm.adx.common.sell.response.VideoMonitor;
import com.bxm.adx.common.sell.response.WinNotice;
import com.bxm.adx.plugins.jincheng.JcConstant;
import com.bxm.adx.plugins.jincheng.JinChengBuyRequest;
import com.bxm.adx.plugins.jincheng.JinChengBuyResponse;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JinChengBuyModelAdapter
extends AbstractFastjsonBuyModelAdapter {
    private static final Logger log = LoggerFactory.getLogger(JinChengBuyModelAdapter.class);
    private PositionDao positionDao;
    private DispatcherDao dispatcherDao;
    private DspService dspService;

    public JinChengBuyModelAdapter(PositionDao positionDao, DispatcherDao dispatcherDao, DspService dspService) {
        this.positionDao = positionDao;
        this.dispatcherDao = dispatcherDao;
        this.dspService = dspService;
    }

    public byte[] buildRequest(BidRequest request) {
        return JsonHelper.convert2bytes((Object)this.convert(request));
    }

    public BidResponse buildResponse(byte[] response) {
        if (log.isDebugEnabled()) {
            log.debug("resp body{}", (Object)StringHelper.convert((byte[])response));
        }
        JinChengBuyResponse r = (JinChengBuyResponse)((Object)JsonHelper.convert((byte[])response, JinChengBuyResponse.class));
        List<JinChengBuyResponse.Ad> ads = r.getAd();
        BidResponse br = new BidResponse();
        if (r.getRcd() == 1) {
            ArrayList<SeatBid> seatBids = new ArrayList<SeatBid>();
            br.setSeat_bid(seatBids);
            SeatBid seatBid = new SeatBid();
            seatBids.add(seatBid);
            ArrayList<Bid> bids = new ArrayList<Bid>();
            seatBid.setBid(bids);
            for (JinChengBuyResponse.Ad ad : ads) {
                Bid bid = new Bid();
                bid.setPrice(Float.valueOf(ad.getEcpm().floatValue() * 100.0f));
                AdxConstants.Type type = JcConstant.AT.getAdxBidType(ad.getAt());
                if (type == null) {
                    throw new RuntimeException("type not support");
                }
                Native n = new Native();
                ArrayList<Asset> assets = new ArrayList<Asset>();
                n.setAssets(assets);
                switch (type) {
                    case NATIVE: {
                        Asset i = this.buildImage(ad);
                        assets.add(i);
                        Asset t = this.buildText(ad);
                        assets.add(t);
                        break;
                    }
                    case IMAGE: {
                        Asset im = this.buildImage(ad);
                        assets.add(im);
                        break;
                    }
                    case VIDEO: {
                        Asset v = this.buildVideo(ad);
                        assets.add(v);
                    }
                }
                bid.setType(type.getType());
                bid.setA_native(n);
                bid.setClick_monitors(this.bulidClickMonitor(ad.getEc()));
                bid.setImp_monitors(this.bulidImpMonitor(ad.getEs()));
                bid.setApk_name(ad.getPack());
                bid.setApp_monitor(this.bulidAppMonitor(ad));
                if (ad.getAct().intValue() == JcConstant.Act.WEB_VIEW.getAct()) {
                    bid.setC_type(Integer.valueOf(AdxConstants.Action.WEB_VIEW.getAction()));
                } else if (ad.getAct().intValue() == JcConstant.Act.DIRECT_DOWNLOAD.getAct()) {
                    bid.setC_type(Integer.valueOf(AdxConstants.Action.DOWNLOAD_ANDROID.getAction()));
                } else {
                    throw new IllegalArgumentException("not support");
                }
                Integer dpl = ad.getDeeplinktype();
                if (JcConstant.DeepLinkType.NO == dpl) {
                    bid.setClick_through_url(ad.getClk());
                } else if (JcConstant.DeepLinkType.TYPE_1 == dpl) {
                    bid.setClick_through_url(ad.getClk());
                    bid.setDeep_link_url(ad.getDeeplink());
                } else if (JcConstant.DeepLinkType.TYPE_2 == dpl) {
                    bid.setClick_through_url(ad.getClk());
                    bid.setDeep_link_url(ad.getDeeplink());
                }
                WinNotice winNotice = new WinNotice();
                winNotice.setWin_notice_url(ad.getWurl());
                bid.setWin_notice(winNotice);
                bids.add(bid);
            }
        }
        return br;
    }

    public AppMonitor bulidAppMonitor(JinChengBuyResponse.Ad ad) {
        AppMonitor appMonitor = new AppMonitor();
        appMonitor.setDs_urls(ad.getStd());
        appMonitor.setDf_urls(ad.getDcp());
        appMonitor.setSf_urls(ad.getItal());
        appMonitor.setSs_urls(ad.getSital());
        return appMonitor;
    }

    public List<ClickMonitor> bulidClickMonitor(List<String> urls) {
        ArrayList<ClickMonitor> cms = new ArrayList<ClickMonitor>();
        for (String url : urls) {
            ClickMonitor clickMonitor = new ClickMonitor();
            clickMonitor.setClick_monitor_url(url);
            cms.add(clickMonitor);
        }
        return cms;
    }

    public List<ImpMonitor> bulidImpMonitor(List<String> urls) {
        ArrayList<ImpMonitor> ims = new ArrayList<ImpMonitor>();
        for (String url : urls) {
            ImpMonitor impMonitor = new ImpMonitor();
            impMonitor.setImp_monitor_url(url);
            ims.add(impMonitor);
        }
        return ims;
    }

    public Asset buildImage(JinChengBuyResponse.Ad ad) {
        Asset i = new Asset();
        Image image = new Image();
        image.setH(ad.getHeight());
        image.setW(ad.getWidth());
        image.setUrl(ad.getAdl());
        i.setImg(image);
        i.setType(Integer.valueOf(7));
        return i;
    }

    public Asset buildText(JinChengBuyResponse.Ad ad) {
        Asset t = new Asset();
        Text text = new Text();
        text.setText(ad.getAti());
        t.setText(text);
        t.setType(Integer.valueOf(2));
        return t;
    }

    public Asset buildVideo(JinChengBuyResponse.Ad ad) {
        Asset v = new Asset();
        Video video = new Video();
        v.setVideo(video);
        v.setType(Integer.valueOf(11));
        JinChengBuyResponse.Ad.Video av = ad.getVideo();
        if (av.getVidat() == 0) {
            video.setCover_url(ad.getAdl());
        } else if (av.getVidat() == 1) {
            video.setEndcard_url(ad.getAdl());
        }
        video.setDuration(Integer.valueOf(av.getVidt() * 1000));
        video.setUrl(av.getVidl());
        video.setVideo_type(Integer.valueOf(av.getVidat() + 1));
        VideoMonitor videoMonitor = new VideoMonitor();
        videoMonitor.setV_start_urls(av.getVideoTracking().getStart());
        videoMonitor.setV_end_urls(av.getVideoTracking().getEnd());
        videoMonitor.setV_close_urls(av.getVideoTracking().getClose());
        videoMonitor.setV_mute_urls(av.getVideoTracking().getMute());
        videoMonitor.setV_skip_urls(av.getVideoTracking().getSkip());
        videoMonitor.setV_suspend_urls(av.getVideoTracking().getSuspend());
        videoMonitor.setV_half_urls(av.getVideoTracking().getMidPoint());
        videoMonitor.setV_three_quarter_urls(av.getVideoTracking().getThirdQuartile());
        video.setV_monitor(videoMonitor);
        return v;
    }

    private BuyRequest convert(BidRequest request) {
        List imps = request.getImps();
        App rApp = request.getApp();
        Device rDevice = request.getDevice();
        Impression imp = (Impression)imps.get(0);
        Integer instl = imp.getInstl();
        JinChengBuyRequest r = new JinChengBuyRequest();
        r.setN(1);
        r.setApv("1.1.1");
        r.setBid(request.getId());
        String tagId = imp.getTag_id();
        Position position = this.positionDao.getByAppPositionId(tagId);
        Dispatcher d = this.dispatcherDao.getByAppPosId(tagId, "jincheng");
        r.setAid(d.getDspPosid());
        Integer adt = JcConstant.Adt.getAdt(position.getPositionScene().intValue());
        if (null == adt) {
            throw new IllegalArgumentException("unsupport adt");
        }
        r.setAdt(adt);
        r.setCootype(2);
        r.setBidprice(Float.valueOf(d.getDspBasePrice().floatValue() / 100.0f));
        r.setAdsw(imp.getW());
        r.setAdsh(imp.getH());
        JinChengBuyRequest.TerminalInfo ti = new JinChengBuyRequest.TerminalInfo();
        r.setTi(ti);
        ti.setBn(rDevice.getBrand());
        ti.setHt(rDevice.getModel());
        ti.setHm(rDevice.getMake());
        ti.setOs(JcConstant.OS.getOs(rDevice.getOs()));
        ti.setOv(rDevice.getOsv());
        ti.setSw(rDevice.getW());
        ti.setSh(rDevice.getH());
        ti.setCh("p1210@bxm");
        ti.setEi(rDevice.getImei());
        ti.setSi(rDevice.getImsi());
        ti.setNt(3);
        ti.setMac(rDevice.getMac());
        ti.setAndid(rDevice.getDpid());
        ti.setIdfa(rDevice.getIdfa());
        ti.setIp(rDevice.getIp());
        ti.setOid("");
        ti.setUid("");
        ti.setUa(rDevice.getUa());
        ti.setDpi(360);
        ti.setPkg(rApp.getBundle());
        ti.setApnnm(rApp.getName());
        ti.setDplink(0);
        return r;
    }
}

