/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.xinyi;

import com.bxm.adx.common.adapter.AbstractFastjsonBuyModelAdapter;
import com.bxm.adx.common.buy.BuyRequest;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.Native;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.plugins.xinyi.XinyiBuyRequest;
import com.bxm.adx.plugins.xinyi.XinyiBuyResponse;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class XinyiBuyModelAdapter
extends AbstractFastjsonBuyModelAdapter {
    public byte[] buildRequest(BidRequest request) {
        return JsonHelper.convert2bytes((Object)this.convert(request));
    }

    public BidResponse buildResponse(byte[] response) {
        XinyiBuyResponse r = (XinyiBuyResponse)((Object)JsonHelper.convert((byte[])response, XinyiBuyResponse.class));
        BidResponse br = new BidResponse();
        br.setId(r.getId());
        SeatBid seatBid = new SeatBid();
        ArrayList<Bid> bids = new ArrayList<Bid>();
        for (XinyiBuyResponse.Ad ad : r.getAds()) {
            String[] click_trackers;
            String[] impression_trackers;
            XinyiBuyResponse.Image[] images;
            Bid bid = new Bid();
            bid.setCreate_id(ad.getCreative_id());
            bid.setImp_id(ad.getAd_id());
            bid.setW(ad.getWidth());
            bid.setH(ad.getHeight());
            bid.setPrice(Float.valueOf(ad.getPrice().floatValue()));
            Native n = new Native();
            ArrayList<Asset> assets = new ArrayList<Asset>();
            for (XinyiBuyResponse.Image image : images = ad.getImages()) {
                Asset asset = new Asset();
                Image img = new Image();
                img.setUrl(image.getUrl());
                asset.setImg(img);
                assets.add(asset);
            }
            n.setAssets(assets);
            bid.setA_native(n);
            bid.setClick_through_url(ad.getTarget_url());
            ArrayList<ImpMonitor> ims = new ArrayList<ImpMonitor>();
            for (String impression_tracker : impression_trackers = ad.getImpression_trackers()) {
                ImpMonitor im = new ImpMonitor();
                im.setImp_monitor_url(impression_tracker);
                ims.add(im);
            }
            bid.setImp_monitors(ims);
            ArrayList<ClickMonitor> cms = new ArrayList<ClickMonitor>();
            for (String click_tracker : click_trackers = ad.getClick_trackers()) {
                ClickMonitor cm = new ClickMonitor();
                cm.setClick_monitor_url(click_tracker);
                cms.add(cm);
            }
            bid.setClick_monitors(cms);
            bids.add(bid);
        }
        seatBid.setBid(bids);
        br.setSeat_bid((List)Lists.newArrayList((Object[])new SeatBid[]{seatBid}));
        return br;
    }

    private BuyRequest convert(BidRequest request) {
        List imps = request.getImps();
        App rApp = request.getApp();
        Device rDevice = request.getDevice();
        XinyiBuyRequest r = new XinyiBuyRequest();
        r.setId(request.getId());
        r.setVersion("2.0.0");
        XinyiBuyRequest.App app = new XinyiBuyRequest.App();
        app.setName(rApp.getName());
        app.setVersion(null);
        app.setBundle(rApp.getBundle());
        app.setDeeplink_mode(1);
        r.setApp(app);
        XinyiBuyRequest.Device device = new XinyiBuyRequest.Device();
        device.setAndroid_id(rDevice.getImei_md5());
        device.setBrand(null);
        device.setConnection_type(Objects.toString(rDevice.getConnection_type()));
        device.setImei(rDevice.getImei());
        device.setIp(rDevice.getIp());
        device.setMake(rDevice.getMake());
        device.setModel(rDevice.getModel());
        device.setOrientation(null);
        device.setOs(rDevice.getOs());
        device.setOs_version(rDevice.getOsv());
        device.setPlmn(null);
        device.setUser_agent(rDevice.getUa());
        r.setDevice(device);
        XinyiBuyRequest.Ad[] ads = new XinyiBuyRequest.Ad[imps.size()];
        int index = 0;
        for (Impression imp : imps) {
            XinyiBuyRequest.Ad ad = new XinyiBuyRequest.Ad();
            ad.setAd_unit_token(imp.getTag_id());
            ad.setWidth(0);
            ad.setHeight(0);
            ad.setSupport_js(true);
            ads[index++] = ad;
        }
        r.setAds(ads);
        return r;
    }
}

