package com.bxm.adxcounter.facade.constant;

/**
 * 内置统计枚举-ADX<br/>
 * 主要用于facade调用<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 10:51
 */
public enum AdxMtEnum {

    /** 不明的 */
    _OTHER(-99, DotMtEnum._OTHER),

    //-------------------------------  ADX  --------------------------------
    /** ADX竞价请求 */
    _101(101, DotMtEnum._15001),
    /** 分发DSP请求 */
    _102(102, DotMtEnum._15002),
    /** 分发DSP响应,值有填充，可计算填充率 */
    _103(103, DotMtEnum._15003),
    /** ADX竞价响应 */
    _104(104, DotMtEnum._15004),
    /** 创意曝光 */
    _105(105, DotMtEnum._15005),
    /** 创意点击 */
    _106(106, DotMtEnum._15006),
    
    /** 开始播放 */
    _107(107, DotMtEnum._15101),
    /** 播放至1/4 */
    _108(108, DotMtEnum._15102),
    /** 播放至1/2 */
    _109(109, DotMtEnum._15103),
    /** 播放至3/4 */
    _110(110, DotMtEnum._15104),
    /** 播放完成 */
    _111(111, DotMtEnum._15105),
    /** 开启静音播放（用户行为触发，默认行为不上报） */
    _112(112, DotMtEnum._15106),
    /** 视频跳过 */
    _113(113, DotMtEnum._15107),
    /** 视频关闭(客户端释放播放资源) */
    _114(114, DotMtEnum._15108),
    /** 播放暂停 */
    _115(115, DotMtEnum._15109),
    /** 继续播放 */
    _116(116, DotMtEnum._15110),
    
    /** 开始下载应用 */
    _117(117, DotMtEnum._15201),
    /** 下载应用完成 */
    _118(118, DotMtEnum._15202),
    /** 开始安装应用 */
    _119(119, DotMtEnum._15203),
    /** 应用安装完成 */
    _120(120, DotMtEnum._15204),
    /** 视频无法播放，跳转到结束页 */
    _121(121, DotMtEnum._17011),

    /** 开启全屏播放（用户行为触发，默认行为不上报） */
    _122(122, DotMtEnum._15111),
    /** 关闭全屏播放（用户行为触发，默认行为不上报） */
    _123(123, DotMtEnum._15112),
    /** 关闭静音播放（用户行为触发，默认行为不上报） */
    _124(124, DotMtEnum._15113),
    /** 激活,安装完成后直接启动App */
    _125(125, DotMtEnum._15205),
    /** deeplink唤起开始 */
    _126(126, DotMtEnum._15301),
    /** deeplink唤起成功 */
    _127(127, DotMtEnum._15302),
    /** deeplink唤起失败 */
    _128(128, DotMtEnum._15303),
    /** 视频离开(用户切换界面，播放进度仍保留) */
    _129(129, DotMtEnum._15114),

    //-------------------------------  耍呗任务  --------------------------------
    /** 任务下发 */
    _201(201, DotMtEnum._15008),
    /** 任务曝光 */
    _202(202, DotMtEnum._15009),
    /** 任务点击 */
    _203(203, DotMtEnum._15010),
    /** 准备就绪 */
    _204(204, DotMtEnum._15011),
    /** 唤醒完成 */
    _205(205, DotMtEnum._15007),
    /** 唤醒成功 */
    _206(206, DotMtEnum._15012),
    /** 任务请求 */
    _207(207, DotMtEnum._15013),
    /** 任务填充 */
    _208(208, DotMtEnum._15014),
    ;

    /**
     * facade MT
     */
    private int original;
    /**
     * 数据中心MT
     */
    private DotMtEnum[] dotMtEnums;

    AdxMtEnum(int original, DotMtEnum... dotMtEnums) {
        this.original = original;
        this.dotMtEnums = dotMtEnums;
    }

    public int getOriginal() {
        return original;
    }

    public DotMtEnum[] getDotMtEnums() {
        return dotMtEnums;
    }

    /**
     * 根据原值返回枚举
     * @param original 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain AdxMtEnum#_OTHER _OTHER}
     */
    public static AdxMtEnum of(Integer original) {
        AdxMtEnum[] values = values();
        for (AdxMtEnum value : values) {
            if (original == value.getOriginal()) {
                return value;
            }
        }
        return _OTHER;
    }
}
