package com.bxm.adxcounter.facade.service;

import com.bxm.adxcounter.facade.constant.Constants;
import com.bxm.adxcounter.facade.model.UserData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author allen
 * @date 2020-07-17
 * @since 1.0
 */
@FeignClient(Constants.SERVER_NAME)
public interface UserFacadeService {

    /**
     * 获取用户数据
     * @param appId 应用ID
     * @param cuids 用户自定义ID
     * @param date 日期
     * @return 统计数据
     */
    @PostMapping("/userFacadeService/getUserData")
    List<UserData> getUserData(@RequestParam("appId") String appId,
                               @RequestParam("cuids") String[] cuids,
                               @RequestParam("date") String date);
}
