package com.bxm.adxcounter.facade.model;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 埋点参数-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 17:24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AdxCounterDTO extends AbstractCounterDTO {
    
    private static final long serialVersionUID = -537631479506482834L;
    
    /**
     * 模块类型modelType
     * @see com.bxm.adxcounter.facade.constant.AdxMtEnum#getOriginal()
     */
    @ValidateNotNull
    private Integer mt;
    /**
     * 变现猫竞价ID
     */
    private String bidid;
    /**
     * 广告位ID
     */
    private String tagid;
    /**
     * 广告平台ID
     */
    private String dspid;
    /**
     * 创意ID
     */
    private String createid;
    /**
     * 赢价价格（单位：分）
     */
    private String win;
    /**
     * 状态
     */
    private String status;
    /**
     * 活动ID
     */
    private String actid;
    /**
     * 投放场景类型
     */
    private String scene;
    

}
